/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUrlHelper;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketBranchJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketCommitsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketPRsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTagsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTeamJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.Repository;
import com.xebialabs.agatha.crawlers.bitbucket.models.dtos.RepoResponse;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBaseCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketTeamCrawl
extends BitbucketBaseCrawl<BitbucketTeamJobMessage, RepoResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketTeamCrawl.class);
    protected final List<String> repoFilter = this.filters("BITBUCKET_REPOS");

    public BitbucketTeamCrawl(BitbucketCrawler crawler, BitbucketTeamJobMessage message, BaseCrawlerMessage crawlerDataMessage) {
        super(crawler, message, crawlerDataMessage);
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketJobMessage dm = ((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketTeamJobMessage.class, this.message).setUrl(this.nextURL);
            return this.createDataMessage(BitbucketTeamJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<RepoResponse> processBitbucketMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketTeamJobMessage for Team - {}.", (Object)((BitbucketTeamJobMessage)this.message).getTeamName());
        CrawledDataWrappedResponse crawledDataWrappedResponse = this.responseFetcher.fetch(RepoResponse.class, ((BitbucketTeamJobMessage)this.message).crawlUrl());
        this.handleResponse((RepoResponse)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(RepoResponse response) throws CrawlerWorkException {
        logger.debug("Found {} repos in team {}", (Object)response.getValues().size(), (Object)((BitbucketTeamJobMessage)this.message).getTeamName());
        List results = response.getValues();
        List filteredResults = results.stream().filter(r -> this.filter(this.repoFilter, r.getName())).collect(Collectors.toList());
        for (Repository r2 : filteredResults) {
            this.sendAllMessages(r2);
        }
    }

    private void sendAllMessages(Repository r) throws CrawlerWorkException {
        this.sendMessage(r, BitbucketBranchJobMessage.class, r.linkFor("branches"));
        this.sendMessage(r, BitbucketCommitsJobMessage.class, r.linkFor("commits"));
        this.sendMessage(r, BitbucketPRsJobMessage.class, BitbucketUrlHelper.allPRsUrl(r.linkFor("pullrequests"), ((BitbucketCrawler)this.crawler).getOldestValidDate()));
        this.sendMessage(r, BitbucketTagsJobMessage.class, r.linkFor("tags"));
    }

    private <C extends BitbucketRepoJobMessage> void sendMessage(Repository r, Class<C> clazz, String url) throws CrawlerWorkException {
        try {
            BitbucketJobMessage dm = this.populateRepoProperties((BitbucketRepoJobMessage)((Object)((BitbucketCrawler)this.crawler).generateNewMessage(clazz, this.message)), r).setEntityUrl(url);
            ((BitbucketCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(clazz.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private <C extends BitbucketRepoJobMessage> C populateRepoProperties(C m, Repository r) {
        m.setRepoId(r.getUuid()).setRepoName(r.getName()).setRepoFullName(r.getFullName());
        return m;
    }
}

