/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.labels;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.models.Tag;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.converters.TagConverter;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.LabelUM;

public class SystemFieldsAggregator
implements Aggregator<LabelUM, Tag> {
    private String project;
    private String repo;

    public SystemFieldsAggregator(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    @Override
    public void populate(LabelUM um, Tag tag) {
        um.setId(this.generateId(TagConverter.computeHash(tag)));
        um.setTitle(tag.getName());
        if (tag.getDate() != null) {
            um.setStartMs(BitbucketUtil.asDate(tag.getDate()));
        }
    }

    private String generateId(String id) {
        return BitbucketUtil.generateDataId(this.project, this.repo, id);
    }
}

