/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.io.Dns;
import akka.io.Dns$Resolved$;
import akka.io.SimpleDnsCache;
import akka.util.Helpers$;
import akka.util.Helpers$Requiring$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001\u001d\u0011a#\u00138fi\u0006#GM]3tg\u0012s7OU3t_24XM\u001d\u0006\u0003\u0007\u0011\t!![8\u000b\u0003\u0015\tA!Y6lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000b\u0005\u001cGo\u001c:\n\u0005M\u0001\"!B!di>\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u000b\r\f7\r[3\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!AD*j[BdW\r\u00128t\u0007\u0006\u001c\u0007.\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u000511m\u001c8gS\u001e\u0004\"!H\u0012\u000e\u0003yQ!aG\u0010\u000b\u0005\u0001\n\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\t\n1aY8n\u0013\t!cD\u0001\u0004D_:4\u0017n\u001a\u0005\u0006M\u0001!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!J#\u0006\u0005\u0002\u0018\u0001!)Q#\na\u0001-!)1$\na\u00019!9A\u0006\u0001b\u0001\n\u001bi\u0013aD\"bG\",\u0007k\u001c7jGf\u0004&o\u001c9\u0016\u00039z\u0011aL\u0011\u0002a\u0005Ab.\u001a;x_J\\\u0017\r\u001a3sKN\u001chfY1dQ\u0016tC\u000f\u001e7\t\rI\u0002\u0001\u0015!\u0004/\u0003A\u0019\u0015m\u00195f!>d\u0017nY=Qe>\u0004\b\u0005C\u00045\u0001\t\u0007IQB\u001b\u0002/\r\u000b7\r[3Q_2L7-\u001f)s_B4\u0015\r\u001c7cC\u000e\\W#\u0001\u001c\u0010\u0003]\n\u0013\u0001O\u0001\u0015gVtgF\\3u]%tW\r^1eIJtC\u000f\u001e7\t\ri\u0002\u0001\u0015!\u00047\u0003a\u0019\u0015m\u00195f!>d\u0017nY=Qe>\u0004h)\u00197mE\u0006\u001c7\u000e\t\u0005\by\u0001\u0011\r\u0011\"\u0004>\u0003]qUmZ1uSZ,7)Y2iKB{G.[2z!J|\u0007/F\u0001?\u001f\u0005y\u0014%\u0001!\u0002C9,Go^8sW\u0006$GM]3tg:\u001a\u0017m\u00195f]9,w-\u0019;jm\u0016tC\u000f\u001e7\t\r\t\u0003\u0001\u0015!\u0004?\u0003aqUmZ1uSZ,7)Y2iKB{G.[2z!J|\u0007\u000f\t\u0005\b\t\u0002\u0011\r\u0011\"\u0004F\u0003}qUmZ1uSZ,7)Y2iKB{G.[2z!J|\u0007OR1mY\n\f7m[\u000b\u0002\r>\tq)I\u0001I\u0003u\u0019XO\u001c\u0018oKRt\u0013N\\3uC\u0012$'O\f8fO\u0006$\u0018N^3/iRd\u0007B\u0002&\u0001A\u00035a)\u0001\u0011OK\u001e\fG/\u001b<f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u0017\u0010\u0015:pa\u001a\u000bG\u000e\u001c2bG.\u0004\u0003b\u0002'\u0001\u0005\u0004%i!T\u0001\b\r>\u0014XM^3s+\u0005qu\"A(\u001e\u0003}Ha!\u0015\u0001!\u0002\u001bq\u0015\u0001\u0003$pe\u00164XM\u001d\u0011\t\u000fM\u0003!\u0019!C\u0007)\u0006)a*\u001a<feV\tQkD\u0001W;\u0005\u0001\u0001B\u0002-\u0001A\u00035Q+\u0001\u0004OKZ,'\u000f\t\u0005\b5\u0002\u0011\r\u0011\"\u0004\\\u0003=!UMZ1vYR\u0004vn]5uSZ,W#\u0001/\u0010\u0003uk\u0012A\b\u0005\u0007?\u0002\u0001\u000bQ\u0002/\u0002!\u0011+g-Y;miB{7/\u001b;jm\u0016\u0004\u0003\u0002C1\u0001\u0011\u000b\u0007I\u0011\u00022\u0002\u0017\r\f7\r[3Q_2L7-_\u000b\u0002GB\u0011\u0011\u0002Z\u0005\u0003K*\u00111!\u00138u\u0011!9\u0007\u0001#b\u0001\n\u0013\u0011\u0017a\u00058fO\u0006$\u0018N^3DC\u000eDW\rU8mS\u000eL\b\"B5\u0001\t\u0013Q\u0017AB4fiR#H\u000eF\u0002l]n\u0004\"!\u00037\n\u00055T!\u0001\u0002'p]\u001eDQa\u001c5A\u0002A\fA\u0001]1uQB\u0011\u0011\u000f\u001f\b\u0003eZ\u0004\"a\u001d\u0006\u000e\u0003QT!!\u001e\u0004\u0002\rq\u0012xn\u001c;?\u0013\t9(\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<\u000b\u0011\u0015a\b\u000e1\u0001~\u0003!\u0001xn]5uSZ,\u0007CA\u0005\u007f\u0013\ty(BA\u0004C_>dW-\u00198\t\u0013\u0005\r\u0001A1A\u0005\u0002\u0005\u0015\u0011a\u00039pg&$\u0018N^3Ui2,\u0012a\u001b\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003l\u00031\u0001xn]5uSZ,G\u000b\u001e7!\u0011%\ti\u0001\u0001b\u0001\n\u0003\t)!A\u0006oK\u001e\fG/\u001b<f)Rd\u0007bBA\t\u0001\u0001\u0006Ia[\u0001\r]\u0016<\u0017\r^5wKR#H\u000e\t\u0005\b\u0003+\u0001A\u0011IA\f\u0003\u001d\u0011XmY3jm\u0016,\"!!\u0007\u0011\u000f%\tY\"a\b\u0002&%\u0019\u0011Q\u0004\u0006\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u00042!CA\u0011\u0013\r\t\u0019C\u0003\u0002\u0004\u0003:L\bcA\u0005\u0002(%\u0019\u0011\u0011\u0006\u0006\u0003\tUs\u0017\u000e\u001e")
public class InetAddressDnsResolver
implements Actor {
    private int cachePolicy;
    private int negativeCachePolicy;
    public final SimpleDnsCache akka$io$InetAddressDnsResolver$$cache;
    private final Config config;
    private final long positiveTtl;
    private final long negativeTtl;
    private final ActorContext context;
    private final ActorRef self;
    private volatile byte bitmap$0;

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    private final String CachePolicyProp() {
        return "networkaddress.cache.ttl";
    }

    private final String CachePolicyPropFallback() {
        return "sun.net.inetaddr.ttl";
    }

    private final String NegativeCachePolicyProp() {
        return "networkaddress.cache.negative.ttl";
    }

    private final String NegativeCachePolicyPropFallback() {
        return "sun.net.inetaddr.negative.ttl";
    }

    private final int Forever() {
        return -1;
    }

    private final int Never() {
        return 0;
    }

    private final int DefaultPositive() {
        return 30;
    }

    /*
     * WARNING - void declaration
     */
    private int cachePolicy$lzycompute() {
        InetAddressDnsResolver inetAddressDnsResolver = this;
        synchronized (inetAddressDnsResolver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                int n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(Security.getProperty("networkaddress.cache.ttl"))).toInt()).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(System.getProperty("sun.net.inetaddr.ttl"))).toInt())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 30));
                this.cachePolicy = n < 0 ? -1 : var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.cachePolicy;
    }

    private int cachePolicy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.cachePolicy$lzycompute() : this.cachePolicy;
    }

    /*
     * WARNING - void declaration
     */
    private int negativeCachePolicy$lzycompute() {
        InetAddressDnsResolver inetAddressDnsResolver = this;
        synchronized (inetAddressDnsResolver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                int n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(Security.getProperty("networkaddress.cache.negative.ttl"))).toInt()).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(System.getProperty("sun.net.inetaddr.negative.ttl"))).toInt())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                this.negativeCachePolicy = n < 0 ? -1 : var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.negativeCachePolicy;
    }

    private int negativeCachePolicy() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.negativeCachePolicy$lzycompute() : this.negativeCachePolicy;
    }

    private long getTtl(String path, boolean positive) {
        long l;
        String string = this.config.getString(path);
        if ("default".equals(string)) {
            long l2;
            int n = positive ? this.cachePolicy() : this.negativeCachePolicy();
            switch (n) {
                case 0: {
                    l2 = 0L;
                    break;
                }
                default: {
                    if (n > 0) {
                        l2 = TimeUnit.SECONDS.toMillis(n);
                        break;
                    }
                    l2 = Long.MAX_VALUE;
                    break;
                }
            }
            l = l2;
        } else {
            l = "forever".equals(string) ? Long.MAX_VALUE : ("never".equals(string) ? 0L : BoxesRunTime.unboxToLong((Object)Helpers$Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(BoxesRunTime.boxToLong((long)this.config.getDuration(path, TimeUnit.MILLISECONDS))), (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L, (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("akka.io.dns.").append(path).append(" must be 'default', 'forever', 'never' or positive duration").toString())));
        }
        return l;
    }

    public long positiveTtl() {
        return this.positiveTtl;
    }

    public long negativeTtl() {
        return this.negativeTtl;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InetAddressDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Dns.Resolve) {
                    Dns.Resolved resolved;
                    Dns.Resolve resolve = (Dns.Resolve)A1;
                    String name = resolve.name();
                    Option<Dns.Resolved> option = this.$outer.akka$io$InetAddressDnsResolver$$cache.cached(name);
                    if (option instanceof Some) {
                        Dns.Resolved a;
                        Some some = (Some)option;
                        resolved = a = (Dns.Resolved)some.value();
                    } else if (None$.MODULE$.equals(option)) {
                        Dns.Resolved resolved2;
                        try {
                            Dns.Resolved answer = Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)Predef$.MODULE$.wrapRefArray((Object[])InetAddress.getAllByName(name)));
                            if (this.$outer.positiveTtl() != 0L) {
                                this.$outer.akka$io$InetAddressDnsResolver$$cache.put(answer, this.$outer.positiveTtl());
                            }
                            resolved2 = answer;
                        }
                        catch (UnknownHostException e) {
                            Dns.Resolved answer = new Dns.Resolved(name, (Seq<Inet4Address>)((Seq)Seq$.MODULE$.empty()), (Seq<Inet6Address>)((Seq)Seq$.MODULE$.empty()));
                            if (this.$outer.negativeTtl() != 0L) {
                                this.$outer.akka$io$InetAddressDnsResolver$$cache.put(answer, this.$outer.negativeTtl());
                            }
                            resolved2 = answer;
                        }
                        resolved = resolved2;
                    } else {
                        throw new MatchError(option);
                    }
                    Dns.Resolved answer = resolved;
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(answer, this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof Dns.Resolve;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public InetAddressDnsResolver(SimpleDnsCache cache, Config config) {
        this.akka$io$InetAddressDnsResolver$$cache = cache;
        this.config = config;
        Actor.$init$(this);
        this.positiveTtl = this.getTtl("positive-ttl", true);
        this.negativeTtl = this.getTtl("negative-ttl", false);
    }
}

