/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTagJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTagsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.Tag;
import com.xebialabs.agatha.crawlers.bitbucket.models.dtos.TagResponse;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBaseCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketTagsCrawl
extends BitbucketBaseCrawl<BitbucketTagsJobMessage, TagResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketTagsCrawl.class);

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketJobMessage dm = ((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketTagsJobMessage.class, this.message).setUrl(this.nextURL);
            return this.createDataMessage(BitbucketTagsJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    public BitbucketTagsCrawl(BitbucketCrawler crawler, BitbucketTagsJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    @Override
    protected CrawledDataWrappedResponse<TagResponse> processBitbucketMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketTagsJobMessage for team {} , repo {}", (Object)((BitbucketTagsJobMessage)this.message).getTeamName(), (Object)((BitbucketTagsJobMessage)this.message).getRepoName());
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(TagResponse.class, ((BitbucketTagsJobMessage)this.message).crawlUrl());
        this.handleResponse((CrawledDataWrappedResponse<TagResponse>)response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<TagResponse> response) throws CrawlerWorkException {
        TagResponse tagResponse = (TagResponse)((Object)response.getEntity());
        logger.debug("Found {} PRs for team - {}, repo - {}", new Object[]{tagResponse.getValues().size(), ((BitbucketTagsJobMessage)this.message).getTeamName(), ((BitbucketTagsJobMessage)this.message).getRepoName()});
        List tags = tagResponse.getValues().stream().filter(t -> t.isDateAfter(((BitbucketCrawler)this.crawler).getOldestValidDate())).collect(Collectors.toList());
        for (Tag tag : tags) {
            this.sendTagJobMessage(tag);
        }
    }

    private void sendTagJobMessage(Tag tag) throws CrawlerWorkException {
        try {
            BitbucketJobMessage dm = ((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketTagJobMessage.class, this.message).setName(tag.getName()).setVersion(tag.getTarget().getHash()).setUrl(tag.linkFor("self"));
            ((BitbucketCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(BitbucketTagJobMessage.class.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

