/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.pr;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.pr.PullRequestUM;

public class SystemFieldsAggregator
implements Aggregator<PullRequestUM, PullRequest> {
    private String project;
    private String repo;

    public SystemFieldsAggregator(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    @Override
    public void populate(PullRequestUM pullRequestUM, PullRequest pullRequest) {
        pullRequestUM.setTitle(pullRequest.getTitle());
        pullRequestUM.setStartMs(BitbucketUtil.asDate(pullRequest.getCreatedOn()));
        pullRequestUM.setFinishMs(BitbucketUtil.asDate(pullRequest.getUpdatedOn()));
        pullRequestUM.setState(pullRequest.getState());
        pullRequestUM.setId(this.generateId(Integer.toString(pullRequest.getId())));
    }

    private String generateId(String id) {
        return BitbucketUtil.generateDataId(this.project, this.repo, id);
    }
}

