/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.transform.converters;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.pr.AdditionalFieldsAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.pr.OthersAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.pr.SystemFieldsAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.pr.UrlPartsAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.converters.BitbucketUMConverter;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.pr.PullRequestUM;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PRConverter
extends BitbucketUMConverter<PullRequestUM, PullRequest> {
    private String team;
    private String repo;
    public static final String SHA_1 = "SHA-1";

    public PRConverter(String TYPE, String VERSION, String PLUGIN_ID, String PLUGIN_VERSION) {
        super(TYPE, VERSION, PLUGIN_ID, PLUGIN_VERSION, DataSourceTypeEnum.PULL_REQUEST);
    }

    @Override
    protected PullRequestUM transform(PullRequest entity) {
        PullRequestUM pullRequestUM = new PullRequestUM();
        this.aggregators().forEach(aggregator -> aggregator.populate(pullRequestUM, entity));
        return pullRequestUM;
    }

    private List<Aggregator> aggregators() {
        return Stream.of(new SystemFieldsAggregator(this.team, this.repo), new UrlPartsAggregator(this.team, this.repo), new OthersAggregator(this.team, this.repo), new AdditionalFieldsAggregator(this.team, this.repo)).collect(Collectors.toList());
    }

    public String getTeam() {
        return this.team;
    }

    public PRConverter setTeam(String team) {
        this.team = team;
        return this;
    }

    public String getRepo() {
        return this.repo;
    }

    public PRConverter setRepo(String repo) {
        this.repo = repo;
        return this;
    }

    @Override
    protected String id(PullRequestUM entity) {
        return entity.getId();
    }

    @Override
    protected String version(PullRequest entity) {
        return BitbucketUtil.asDate(entity.getUpdatedOn()) + "";
    }
}

