/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.shared.components;

import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.shared.components.CrawlFactory;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;

public abstract class BaseCrawlResolver<C extends AbstractCrawler>
implements CrawlResolver<C> {
    protected final CrawlFactory<C> crawlFactory;

    public BaseCrawlResolver(CrawlFactory<C> crawlFactory) {
        this.crawlFactory = crawlFactory;
    }

    @Override
    public CrawlService resolve(C crawler, CrawlerJobWrapper crawlerJob) throws CrawlerWorkException {
        try {
            if (crawlerJob.getMessage().isLaunch()) {
                return this.handleLaunchCrawlMessage(crawler, crawlerJob);
            }
            return this.handleAllCrawlMessage(crawler, crawlerJob);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    protected abstract CrawlService handleLaunchCrawlMessage(C var1, CrawlerJobWrapper var2) throws IllegalAccessException, InstantiationException;

    protected CrawlService handleAllCrawlMessage(C crawler, CrawlerJobWrapper crawlerJob) throws CrawlerWorkException {
        return this.crawlFactory.getInstance(crawler, crawlerJob.getMessage());
    }
}

