/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTeamJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.Team;
import com.xebialabs.agatha.crawlers.bitbucket.models.dtos.TeamsResponse;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBaseCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketJobCrawl
extends BitbucketBaseCrawl<BitbucketJobMessage, TeamsResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketJobCrawl.class);
    protected final List<String> teamFilter = this.filters("BITBUCKET_TEAM");

    public BitbucketJobCrawl(BitbucketCrawler crawler, BitbucketJobMessage message, BaseCrawlerMessage crawlerDataMessage) {
        super(crawler, message, crawlerDataMessage);
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketJobMessage dm = ((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketJobMessage.class, this.message).setUrl(this.nextURL);
            return this.createDataMessage(BitbucketJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<TeamsResponse> processBitbucketMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketJobMessage for Url {}.", (Object)((BitbucketJobMessage)this.message).getBaseUrl());
        CrawledDataWrappedResponse crawledDataWrappedResponse = this.responseFetcher.fetch(TeamsResponse.class, ((BitbucketJobMessage)this.message).crawlUrl());
        this.handleResponse((TeamsResponse)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(TeamsResponse response) throws CrawlerWorkException {
        logger.debug("Found {} teams in account {}", (Object)response.getValues().size(), (Object)((BitbucketCrawler)this.crawler).getUsername());
        List results = response.getValues();
        List filteredResults = results.stream().filter(r -> this.filter(this.teamFilter, r.getUsername())).collect(Collectors.toList());
        for (Team t : filteredResults) {
            this.sendTeamMessage(t);
        }
    }

    private void sendTeamMessage(Team t) throws CrawlerWorkException {
        try {
            BitbucketTeamJobMessage dm = this.populateTeamAttributes(((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketTeamJobMessage.class, this.message), t);
            ((BitbucketCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(BitbucketTeamJobMessage.class.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private BitbucketTeamJobMessage populateTeamAttributes(BitbucketTeamJobMessage bitbucketTeamJobMessage, Team t) {
        bitbucketTeamJobMessage.setTeamDisplayName(t.getDisplayName()).setTeamId(t.getUuid()).setTeamName(t.getUsername()).setEntityUrl(t.getLinks().getApiUrl("repositories"));
        return bitbucketTeamJobMessage;
    }
}

