/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.google.common.collect.Maps;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTagJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.Tag;
import com.xebialabs.agatha.crawlers.bitbucket.repository.TagRepository;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBaseCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.transform.converters.TagConverter;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.LabelUM;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketTagCrawl
extends BitbucketBaseCrawl<BitbucketTagJobMessage, Tag> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketTagCrawl.class);
    private final UMConverter<LabelUM, Tag> converter;
    private final KeyValueRepository<LabelUM> repository;

    public BitbucketTagCrawl(BitbucketCrawler crawler, BitbucketTagJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.converter = new TagConverter("LABEL", "v1", "BitbucketCloudPlugin", "v1").setTeam(message.getTeamName()).setRepo(message.getRepoName());
        this.repository = new TagRepository(crawler, dataMessage);
    }

    @Override
    protected CrawledDataWrappedResponse<Tag> processBitbucketMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketTagJobMessage for endpoint {}, tag - {}, - team {}, repo - {} ", new Object[]{((BitbucketTagJobMessage)this.message).getBaseUrl(), ((BitbucketTagJobMessage)this.message).getName(), ((BitbucketTagJobMessage)this.message).getTeamName(), ((BitbucketTagJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(Tag.class, ((BitbucketTagJobMessage)this.message).crawlUrl());
        this.handleResponse((Tag)response.getEntity());
        return null;
    }

    private void handleResponse(Tag tag) throws CrawlerWorkException {
        logger.debug("Saving Tag {} in team - {}, repo - {}", new Object[]{tag.getName(), ((BitbucketTagJobMessage)this.message).getTeamName(), ((BitbucketTagJobMessage)this.message).getRepoName()});
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)tag);
        boolean crawlCommits = this.repository.save(umWrappedEntity);
        this.crawlCommit(crawlCommits, tag);
    }

    private void crawlCommit(boolean crawlCommits, Tag tag) throws CrawlerWorkException {
        if (crawlCommits) {
            logger.debug("Pushing {} Tag commit depth jobs ", (Object)tag.getName());
            this.crawlCommitMessage((BitbucketRepoJobMessage)this.message, tag.linkFor("commits"), Maps.immutableEntry((Object)tag.getTarget().getHash(), (Object)tag.getTarget().fetchUrl()));
        }
    }
}

