/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.CrawlerExecutor;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.BitbucketServerCrawlResolver;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawlService;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.ReposResponse;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketServerCrawler
extends AbstractHttpCrawler {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketServerCrawler.class);
    private static final String AUTHORIZED_REPOS = "/rest/api/1.0/repos?permission=REPO_READ&limit=1";
    private final CrawlResolver<BitbucketServerCrawler> crawlResolver = new BitbucketServerCrawlResolver();

    public BitbucketServerCrawler() {
        super("BitbucketServerPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD);
    }

    public BitbucketServerCrawler(Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super("BitbucketServerPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD, ingestionApiProvider);
    }

    protected ObjectMapper createMapper() {
        ObjectMapper mapper = super.createMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    protected CrawlerJobResult crawlItem(CrawlerJobWrapper crawlerJob) {
        try {
            CrawlService crawl = this.crawlResolver.resolve(this, crawlerJob);
            crawl.execute();
            return CrawlerJobResult.success();
        }
        catch (CrawlerWorkException e) {
            return CrawlerJobResult.fail((String)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ProbeResultMetadataVM probe(CrawlerJobWrapper crawlerJob) {
        Request request;
        ProbeResultMetadataVM result = new ProbeResultMetadataVM().setEndpoint(this.endpoint.toString()).setUsername(this.username);
        try {
            request = new Request.Builder().url(new URL(this.getEndpoint(), AUTHORIZED_REPOS)).build();
        }
        catch (MalformedURLException e) {
            logger.warn("Cannot construct BitbucketServer probe URL!");
            return result.setSuccess(false).setReason(e.getMessage());
        }
        try (Response response = ((OkHttpClient)this.getClient()).newCall(request).execute();){
            if (this.isProbeSuccessful(response)) {
                ProbeResultMetadataVM probeResultMetadataVM2 = result.setSuccess(true);
                return probeResultMetadataVM2;
            }
            logger.warn("BitbucketServer probe was not successful for user: {}", (Object)this.username);
            ProbeResultMetadataVM probeResultMetadataVM = result.setSuccess(false).setReason("Status: " + response.code());
            return probeResultMetadataVM;
        }
        catch (IOException e) {
            logger.warn("BitbucketServer probe was not successful for user: {}", (Object)this.username);
            return result.setSuccess(false).setReason(e.getMessage());
        }
    }

    private boolean isProbeSuccessful(Response response) throws IOException {
        if (response.isSuccessful()) {
            String content = response.body().string();
            ReposResponse parsedProbeResponse = (ReposResponse)this.mapper.readValue(content, ReposResponse.class);
            if (parsedProbeResponse.isEmpty()) {
                logger.info("No repos found for user: {}", (Object)this.username);
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error(e.getMessage(), e));
        new CrawlerExecutor(BitbucketServerCrawler::new).execute();
    }

    public <V extends BaseCrawlerMessage> V generateNewMessage(Class<V> cls, BaseCrawlerMessage oldMsg) throws IllegalAccessException, InstantiationException {
        BitbucketServerJobMessage old;
        BitbucketServerJobMessage newMsg;
        BaseCrawlerMessage v = super.generateNewMessage(cls, oldMsg);
        if (v instanceof BitbucketServerJobMessage && oldMsg instanceof BitbucketServerJobMessage) {
            newMsg = (BitbucketServerJobMessage)v;
            old = (BitbucketServerJobMessage)oldMsg;
            newMsg.setBaseUrl(old.getBaseUrl());
        }
        if (v instanceof BitbucketServerRepoJobMessage && oldMsg instanceof BitbucketServerRepoJobMessage) {
            newMsg = (BitbucketServerRepoJobMessage)v;
            old = (BitbucketServerRepoJobMessage)oldMsg;
            ((BitbucketServerRepoJobMessage)newMsg).setProjectId(((BitbucketServerRepoJobMessage)old).getProjectId());
            ((BitbucketServerRepoJobMessage)newMsg).setProjectKey(((BitbucketServerRepoJobMessage)old).getProjectKey());
            ((BitbucketServerRepoJobMessage)newMsg).setProjectName(((BitbucketServerRepoJobMessage)old).getProjectName());
            ((BitbucketServerRepoJobMessage)newMsg).setRepoId(((BitbucketServerRepoJobMessage)old).getRepoId());
            ((BitbucketServerRepoJobMessage)newMsg).setRepoName(((BitbucketServerRepoJobMessage)old).getRepoName());
            ((BitbucketServerRepoJobMessage)newMsg).setRepoSlug(((BitbucketServerRepoJobMessage)old).getRepoSlug());
            newMsg.setBaseUrl(old.getBaseUrl());
        }
        v.setDataKey(cls.getSimpleName());
        return (V)v;
    }
}

