/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.components;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.ResponseFetcher;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.ChangeLog;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Diff;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.DiffsResponse;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.net.URL;
import java.util.Collection;
import java.util.List;

public class DiffCalculator {
    private final ResponseFetcher<BitbucketServerCrawler> responseFetcher;

    public DiffCalculator(BitbucketServerCrawler crawler) {
        this.responseFetcher = new ResponseFetcher<BitbucketServerCrawler>(crawler);
    }

    public ChangeLog changeLogFromDiff(URL url) throws CrawlerWorkException {
        CrawledDataWrappedResponse<DiffsResponse> response = this.responseFetcher.fetchEntity(DiffsResponse.class, url);
        if (CrawledDataWrappedResponse.isEmpty(response)) {
            return new ChangeLog(0, 0);
        }
        List<Diff> diffs = response.getEntity().getValues();
        return new ChangeLog(this.numberOfFilesChanged(diffs), this.numberOfLinesChanged(diffs));
    }

    private int numberOfFilesChanged(List<Diff> diffs) {
        return diffs == null ? 0 : diffs.size();
    }

    private int numberOfLinesChanged(List<Diff> diffs) {
        if (diffs == null || diffs.isEmpty()) {
            return 0;
        }
        Long linesChanged = diffs.stream().filter(d -> d.getHunks() != null).map(Diff::getHunks).flatMap(Collection::stream).flatMap(changeSet -> changeSet.getSegments().stream()).filter(DiffCalculator::isModified).flatMap(segment -> segment.getLines().stream()).count();
        return linesChanged.intValue();
    }

    private static boolean isModified(Diff.Segment segment) {
        return segment.getType().equalsIgnoreCase("added") || segment.getType().equalsIgnoreCase("removed");
    }
}

