/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.services;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerURLHelper;
import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerUtil;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.DiffCalculator;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerCommitJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Sha;
import com.xebialabs.agatha.crawlers.bitbucketserver.repository.CommitRepository;
import com.xebialabs.agatha.crawlers.bitbucketserver.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BaseEntityCrawl;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters.CommitConverter;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters.UMConverter;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.CommitUM;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.net.URL;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketServerCommitJobCrawl
extends BaseEntityCrawl<BitbucketServerCommitJobMessage, Commit> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketServerCommitJobCrawl.class);
    private final UMConverter<CommitUM, Commit> converter;
    private final KeyValueRepository<CommitUM> repository;
    private final DiffCalculator diffCalculator;

    public BitbucketServerCommitJobCrawl(BitbucketServerCrawler crawler, BitbucketServerCommitJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.converter = new CommitConverter("BitbucketServerPlugin", "v1", "COMMIT", "v1").setProject(message.getProjectKey()).setRepo(message.getRepoSlug());
        this.repository = new CommitRepository(crawler, dataMessage);
        this.diffCalculator = new DiffCalculator(crawler);
    }

    @Override
    protected boolean valid() {
        return this.crawler.decideToContinueBeforeCrawling(this.dataMessage, ((BitbucketServerCommitJobMessage)this.message).getId(), BitbucketServerUtil.generateDataId(((BitbucketServerCommitJobMessage)this.message).getProjectKey(), ((BitbucketServerCommitJobMessage)this.message).getRepoSlug(), ((BitbucketServerCommitJobMessage)this.message).getId()), DataSourceTypeEnum.COMMIT);
    }

    @Override
    protected CrawledDataWrappedResponse<Commit> processMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketServerCommitJobMessage for endpoint {}, commit - {}, - project {}, repo - {} ", new Object[]{((BitbucketServerCommitJobMessage)this.message).getBaseUrl(), ((BitbucketServerCommitJobMessage)this.message).getId(), ((BitbucketServerCommitJobMessage)this.message).getProjectKey(), ((BitbucketServerCommitJobMessage)this.message).getRepoSlug()});
        CrawledDataWrappedResponse<Commit> response = this.responseFetcher.fetchEntity(Commit.class, ((BitbucketServerCommitJobMessage)this.message).url());
        this.handleResponse(response.getEntity());
        return response;
    }

    private void handleResponse(Commit c) throws CrawlerWorkException {
        if (!this.isValidCommit(c)) {
            return;
        }
        logger.debug("Saving commit {} in project - {}, repo - {}", new Object[]{c.getId(), ((BitbucketServerCommitJobMessage)this.message).getProjectKey(), ((BitbucketServerCommitJobMessage)this.message).getRepoSlug()});
        this.enrichCommit(c);
        UMWrappedEntity<CommitUM> umWrappedEntity = this.converter.convert(c);
        boolean crawlParents = this.repository.save(umWrappedEntity);
        if (crawlParents) {
            logger.debug("Pushing {} parent commit depth jobs from commit {}", (Object)c.getParents().size(), (Object)c.getId());
            this.sendCommitDepthJobMessages((BitbucketServerRepoJobMessage)this.message, c.getParents().stream().map(Sha::getId).collect(Collectors.toSet()));
        }
    }

    private void enrichCommit(Commit c) throws CrawlerWorkException {
        c.setChangeLog(this.diffCalculator.changeLogFromDiff(this.diffUrl()));
    }

    private URL diffUrl() throws CrawlerWorkException {
        return BitbucketServerURLHelper.diffsURL(((BitbucketServerCommitJobMessage)this.message).getBaseUrl(), ((BitbucketServerCommitJobMessage)this.message).getProjectKey(), ((BitbucketServerCommitJobMessage)this.message).getRepoSlug(), "commits", ((BitbucketServerCommitJobMessage)this.message).getId());
    }
}

