/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.repository;

import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.generators.KeyValueCoordinatesGenerator;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;

public abstract class BaseRepository<C extends AbstractCrawler, E>
implements KeyValueRepository<E> {
    protected final C crawler;
    protected final BaseCrawlerMessage dataMessage;

    public BaseRepository(C crawler, BaseCrawlerMessage dataMessage) {
        this.crawler = crawler;
        this.dataMessage = dataMessage;
    }

    protected boolean save(UMWrappedEntity<E> umData, KeyValueCoordinatesGenerator generator) throws CrawlerWorkException {
        return this.crawler.sendCrawledDataAndDecideToContinue(this.dataMessage, umData.getWrappedData(), umData.getDataSourceType(), generator.artifactId(), generator.version());
    }

    static class DefaultKeyValueCoordinatesGenerator<E>
    implements KeyValueCoordinatesGenerator {
        private final UMWrappedEntity<E> umData;

        DefaultKeyValueCoordinatesGenerator(UMWrappedEntity<E> umData) {
            this.umData = umData;
        }

        @Override
        public String artifactId() {
            return this.umData.getId();
        }

        @Override
        public String version() {
            return this.umData.getVersion();
        }
    }
}

