/*
 * Decompiled with CFR 0.152.
 */
package akka.protobuf;

import akka.protobuf.ByteString;
import akka.protobuf.DescriptorProtos;
import akka.protobuf.ExtensionRegistry;
import akka.protobuf.ExtensionRegistryLite;
import akka.protobuf.FieldSet;
import akka.protobuf.Internal;
import akka.protobuf.InvalidProtocolBufferException;
import akka.protobuf.Message;
import akka.protobuf.MessageLite;
import akka.protobuf.TextFormat;
import akka.protobuf.WireFormat;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Descriptors {
    private static String computeFullName(FileDescriptor fileDescriptor, Descriptor descriptor, String string) {
        if (descriptor != null) {
            return descriptor.getFullName() + '.' + string;
        }
        if (fileDescriptor.getPackage().length() > 0) {
            return fileDescriptor.getPackage() + '.' + string;
        }
        return string;
    }

    private static final class DescriptorPool {
        private final Set<FileDescriptor> dependencies;
        private final Map<String, GenericDescriptor> descriptorsByName = new HashMap<String, GenericDescriptor>();
        private final Map<DescriptorIntPair, FieldDescriptor> fieldsByNumber = new HashMap<DescriptorIntPair, FieldDescriptor>();
        private final Map<DescriptorIntPair, EnumValueDescriptor> enumValuesByNumber = new HashMap<DescriptorIntPair, EnumValueDescriptor>();

        DescriptorPool(FileDescriptor[] fileDescriptorArray) {
            this.dependencies = new HashSet<FileDescriptor>();
            for (int i = 0; i < fileDescriptorArray.length; ++i) {
                this.dependencies.add(fileDescriptorArray[i]);
                this.importPublicDependencies(fileDescriptorArray[i]);
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                try {
                    this.addPackage(fileDescriptor.getPackage(), fileDescriptor);
                }
                catch (DescriptorValidationException descriptorValidationException) {
                    assert (false);
                }
            }
        }

        private void importPublicDependencies(FileDescriptor fileDescriptor) {
            for (FileDescriptor fileDescriptor2 : fileDescriptor.getPublicDependencies()) {
                if (!this.dependencies.add(fileDescriptor2)) continue;
                this.importPublicDependencies(fileDescriptor2);
            }
        }

        GenericDescriptor findSymbol(String string) {
            return this.findSymbol(string, SearchFilter.ALL_SYMBOLS);
        }

        GenericDescriptor findSymbol(String string, SearchFilter searchFilter) {
            GenericDescriptor genericDescriptor = this.descriptorsByName.get(string);
            if (genericDescriptor != null && (searchFilter == SearchFilter.ALL_SYMBOLS || searchFilter == SearchFilter.TYPES_ONLY && this.isType(genericDescriptor) || searchFilter == SearchFilter.AGGREGATES_ONLY && this.isAggregate(genericDescriptor))) {
                return genericDescriptor;
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                genericDescriptor = ((FileDescriptor)fileDescriptor).pool.descriptorsByName.get(string);
                if (genericDescriptor == null || searchFilter != SearchFilter.ALL_SYMBOLS && (searchFilter != SearchFilter.TYPES_ONLY || !this.isType(genericDescriptor)) && (searchFilter != SearchFilter.AGGREGATES_ONLY || !this.isAggregate(genericDescriptor))) continue;
                return genericDescriptor;
            }
            return null;
        }

        boolean isType(GenericDescriptor genericDescriptor) {
            return genericDescriptor instanceof Descriptor || genericDescriptor instanceof EnumDescriptor;
        }

        boolean isAggregate(GenericDescriptor genericDescriptor) {
            return genericDescriptor instanceof Descriptor || genericDescriptor instanceof EnumDescriptor || genericDescriptor instanceof PackageDescriptor || genericDescriptor instanceof ServiceDescriptor;
        }

        GenericDescriptor lookupSymbol(String string, GenericDescriptor genericDescriptor, SearchFilter searchFilter) throws DescriptorValidationException {
            GenericDescriptor genericDescriptor2;
            if (string.startsWith(".")) {
                genericDescriptor2 = this.findSymbol(string.substring(1), searchFilter);
            } else {
                int n = string.indexOf(46);
                String string2 = n == -1 ? string : string.substring(0, n);
                StringBuilder stringBuilder = new StringBuilder(genericDescriptor.getFullName());
                while (true) {
                    int n2;
                    if ((n2 = stringBuilder.lastIndexOf(".")) == -1) {
                        genericDescriptor2 = this.findSymbol(string, searchFilter);
                        break;
                    }
                    stringBuilder.setLength(n2 + 1);
                    stringBuilder.append(string2);
                    genericDescriptor2 = this.findSymbol(stringBuilder.toString(), SearchFilter.AGGREGATES_ONLY);
                    if (genericDescriptor2 != null) {
                        if (n == -1) break;
                        stringBuilder.setLength(n2 + 1);
                        stringBuilder.append(string);
                        genericDescriptor2 = this.findSymbol(stringBuilder.toString(), searchFilter);
                        break;
                    }
                    stringBuilder.setLength(n2);
                }
            }
            if (genericDescriptor2 == null) {
                throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is not defined.");
            }
            return genericDescriptor2;
        }

        void addSymbol(GenericDescriptor genericDescriptor) throws DescriptorValidationException {
            DescriptorPool.validateSymbolName(genericDescriptor);
            String string = genericDescriptor.getFullName();
            int n = string.lastIndexOf(46);
            GenericDescriptor genericDescriptor2 = this.descriptorsByName.put(string, genericDescriptor);
            if (genericDescriptor2 != null) {
                this.descriptorsByName.put(string, genericDescriptor2);
                if (genericDescriptor.getFile() == genericDescriptor2.getFile()) {
                    if (n == -1) {
                        throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is already defined.");
                    }
                    throw new DescriptorValidationException(genericDescriptor, '\"' + string.substring(n + 1) + "\" is already defined in \"" + string.substring(0, n) + "\".");
                }
                throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is already defined in file \"" + genericDescriptor2.getFile().getName() + "\".");
            }
        }

        void addPackage(String string, FileDescriptor fileDescriptor) throws DescriptorValidationException {
            String string2;
            int n = string.lastIndexOf(46);
            if (n == -1) {
                string2 = string;
            } else {
                this.addPackage(string.substring(0, n), fileDescriptor);
                string2 = string.substring(n + 1);
            }
            GenericDescriptor genericDescriptor = this.descriptorsByName.put(string, new PackageDescriptor(string2, string, fileDescriptor));
            if (genericDescriptor != null) {
                this.descriptorsByName.put(string, genericDescriptor);
                if (!(genericDescriptor instanceof PackageDescriptor)) {
                    throw new DescriptorValidationException(fileDescriptor, '\"' + string2 + "\" is already defined (as something other than a package) in file \"" + genericDescriptor.getFile().getName() + "\".");
                }
            }
        }

        void addFieldByNumber(FieldDescriptor fieldDescriptor) throws DescriptorValidationException {
            DescriptorIntPair descriptorIntPair = new DescriptorIntPair(fieldDescriptor.getContainingType(), fieldDescriptor.getNumber());
            FieldDescriptor fieldDescriptor2 = this.fieldsByNumber.put(descriptorIntPair, fieldDescriptor);
            if (fieldDescriptor2 != null) {
                this.fieldsByNumber.put(descriptorIntPair, fieldDescriptor2);
                throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "Field number " + fieldDescriptor.getNumber() + "has already been used in \"" + fieldDescriptor.getContainingType().getFullName() + "\" by field \"" + fieldDescriptor2.getName() + "\".");
            }
        }

        void addEnumValueByNumber(EnumValueDescriptor enumValueDescriptor) {
            DescriptorIntPair descriptorIntPair = new DescriptorIntPair(enumValueDescriptor.getType(), enumValueDescriptor.getNumber());
            EnumValueDescriptor enumValueDescriptor2 = this.enumValuesByNumber.put(descriptorIntPair, enumValueDescriptor);
            if (enumValueDescriptor2 != null) {
                this.enumValuesByNumber.put(descriptorIntPair, enumValueDescriptor2);
            }
        }

        static void validateSymbolName(GenericDescriptor genericDescriptor) throws DescriptorValidationException {
            String string = genericDescriptor.getName();
            if (string.length() == 0) {
                throw new DescriptorValidationException(genericDescriptor, "Missing name.");
            }
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= '\u0080') {
                    bl = false;
                }
                if (Character.isLetter(c) || c == '_' || Character.isDigit(c) && i > 0) continue;
                bl = false;
            }
            if (!bl) {
                throw new DescriptorValidationException(genericDescriptor, '\"' + string + "\" is not a valid identifier.");
            }
        }

        private static final class DescriptorIntPair {
            private final GenericDescriptor descriptor;
            private final int number;

            DescriptorIntPair(GenericDescriptor genericDescriptor, int n) {
                this.descriptor = genericDescriptor;
                this.number = n;
            }

            public int hashCode() {
                return this.descriptor.hashCode() * 65535 + this.number;
            }

            public boolean equals(Object object) {
                if (!(object instanceof DescriptorIntPair)) {
                    return false;
                }
                DescriptorIntPair descriptorIntPair = (DescriptorIntPair)object;
                return this.descriptor == descriptorIntPair.descriptor && this.number == descriptorIntPair.number;
            }
        }

        private static final class PackageDescriptor
        implements GenericDescriptor {
            private final String name;
            private final String fullName;
            private final FileDescriptor file;

            @Override
            public Message toProto() {
                return this.file.toProto();
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getFullName() {
                return this.fullName;
            }

            @Override
            public FileDescriptor getFile() {
                return this.file;
            }

            PackageDescriptor(String string, String string2, FileDescriptor fileDescriptor) {
                this.file = fileDescriptor;
                this.fullName = string2;
                this.name = string;
            }
        }

        static enum SearchFilter {
            TYPES_ONLY,
            AGGREGATES_ONLY,
            ALL_SYMBOLS;

        }
    }

    public static class DescriptorValidationException
    extends Exception {
        private static final long serialVersionUID = 5750205775490483148L;
        private final String name;
        private final Message proto;
        private final String description;

        public String getProblemSymbolName() {
            return this.name;
        }

        public Message getProblemProto() {
            return this.proto;
        }

        public String getDescription() {
            return this.description;
        }

        private DescriptorValidationException(GenericDescriptor genericDescriptor, String string) {
            super(genericDescriptor.getFullName() + ": " + string);
            this.name = genericDescriptor.getFullName();
            this.proto = genericDescriptor.toProto();
            this.description = string;
        }

        private DescriptorValidationException(GenericDescriptor genericDescriptor, String string, Throwable throwable) {
            this(genericDescriptor, string);
            this.initCause(throwable);
        }

        private DescriptorValidationException(FileDescriptor fileDescriptor, String string) {
            super(fileDescriptor.getName() + ": " + string);
            this.name = fileDescriptor.getName();
            this.proto = fileDescriptor.toProto();
            this.description = string;
        }
    }

    private static interface GenericDescriptor {
        public Message toProto();

        public String getName();

        public String getFullName();

        public FileDescriptor getFile();
    }

    public static final class MethodDescriptor
    implements GenericDescriptor {
        private final int index;
        private DescriptorProtos.MethodDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final ServiceDescriptor service;
        private Descriptor inputType;
        private Descriptor outputType;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.MethodDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public ServiceDescriptor getService() {
            return this.service;
        }

        public Descriptor getInputType() {
            return this.inputType;
        }

        public Descriptor getOutputType() {
            return this.outputType;
        }

        public DescriptorProtos.MethodOptions getOptions() {
            return this.proto.getOptions();
        }

        private MethodDescriptor(DescriptorProtos.MethodDescriptorProto methodDescriptorProto, FileDescriptor fileDescriptor, ServiceDescriptor serviceDescriptor, int n) throws DescriptorValidationException {
            this.index = n;
            this.proto = methodDescriptorProto;
            this.file = fileDescriptor;
            this.service = serviceDescriptor;
            this.fullName = serviceDescriptor.getFullName() + '.' + methodDescriptorProto.getName();
            fileDescriptor.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor = this.file.pool.lookupSymbol(this.proto.getInputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getInputType() + "\" is not a message type.");
            }
            this.inputType = (Descriptor)genericDescriptor;
            GenericDescriptor genericDescriptor2 = this.file.pool.lookupSymbol(this.proto.getOutputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(genericDescriptor2 instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getOutputType() + "\" is not a message type.");
            }
            this.outputType = (Descriptor)genericDescriptor2;
        }

        private void setProto(DescriptorProtos.MethodDescriptorProto methodDescriptorProto) {
            this.proto = methodDescriptorProto;
        }
    }

    public static final class ServiceDescriptor
    implements GenericDescriptor {
        private final int index;
        private DescriptorProtos.ServiceDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private MethodDescriptor[] methods;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.ServiceDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public DescriptorProtos.ServiceOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<MethodDescriptor> getMethods() {
            return Collections.unmodifiableList(Arrays.asList(this.methods));
        }

        public MethodDescriptor findMethodByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor != null && genericDescriptor instanceof MethodDescriptor) {
                return (MethodDescriptor)genericDescriptor;
            }
            return null;
        }

        private ServiceDescriptor(DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto, FileDescriptor fileDescriptor, int n) throws DescriptorValidationException {
            this.index = n;
            this.proto = serviceDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, null, serviceDescriptorProto.getName());
            this.file = fileDescriptor;
            this.methods = new MethodDescriptor[serviceDescriptorProto.getMethodCount()];
            for (int i = 0; i < serviceDescriptorProto.getMethodCount(); ++i) {
                this.methods[i] = new MethodDescriptor(serviceDescriptorProto.getMethod(i), fileDescriptor, this, i);
            }
            fileDescriptor.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            for (MethodDescriptor methodDescriptor : this.methods) {
                methodDescriptor.crossLink();
            }
        }

        private void setProto(DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto) {
            this.proto = serviceDescriptorProto;
            for (int i = 0; i < this.methods.length; ++i) {
                this.methods[i].setProto(serviceDescriptorProto.getMethod(i));
            }
        }
    }

    public static final class EnumValueDescriptor
    implements GenericDescriptor,
    Internal.EnumLite {
        private final int index;
        private DescriptorProtos.EnumValueDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final EnumDescriptor type;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.EnumValueDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public int getNumber() {
            return this.proto.getNumber();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public EnumDescriptor getType() {
            return this.type;
        }

        public DescriptorProtos.EnumValueOptions getOptions() {
            return this.proto.getOptions();
        }

        private EnumValueDescriptor(DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto, FileDescriptor fileDescriptor, EnumDescriptor enumDescriptor, int n) throws DescriptorValidationException {
            this.index = n;
            this.proto = enumValueDescriptorProto;
            this.file = fileDescriptor;
            this.type = enumDescriptor;
            this.fullName = enumDescriptor.getFullName() + '.' + enumValueDescriptorProto.getName();
            fileDescriptor.pool.addSymbol(this);
            fileDescriptor.pool.addEnumValueByNumber(this);
        }

        private void setProto(DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto) {
            this.proto = enumValueDescriptorProto;
        }
    }

    public static final class EnumDescriptor
    implements GenericDescriptor,
    Internal.EnumLiteMap<EnumValueDescriptor> {
        private final int index;
        private DescriptorProtos.EnumDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private EnumValueDescriptor[] values;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.EnumDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public DescriptorProtos.EnumOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<EnumValueDescriptor> getValues() {
            return Collections.unmodifiableList(Arrays.asList(this.values));
        }

        public EnumValueDescriptor findValueByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor != null && genericDescriptor instanceof EnumValueDescriptor) {
                return (EnumValueDescriptor)genericDescriptor;
            }
            return null;
        }

        @Override
        public EnumValueDescriptor findValueByNumber(int n) {
            return (EnumValueDescriptor)this.file.pool.enumValuesByNumber.get(new DescriptorPool.DescriptorIntPair(this, n));
        }

        private EnumDescriptor(DescriptorProtos.EnumDescriptorProto enumDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n) throws DescriptorValidationException {
            this.index = n;
            this.proto = enumDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, enumDescriptorProto.getName());
            this.file = fileDescriptor;
            this.containingType = descriptor;
            if (enumDescriptorProto.getValueCount() == 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Enums must contain at least one value.");
            }
            this.values = new EnumValueDescriptor[enumDescriptorProto.getValueCount()];
            for (int i = 0; i < enumDescriptorProto.getValueCount(); ++i) {
                this.values[i] = new EnumValueDescriptor(enumDescriptorProto.getValue(i), fileDescriptor, this, i);
            }
            fileDescriptor.pool.addSymbol(this);
        }

        private void setProto(DescriptorProtos.EnumDescriptorProto enumDescriptorProto) {
            this.proto = enumDescriptorProto;
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].setProto(enumDescriptorProto.getValue(i));
            }
        }
    }

    public static final class FieldDescriptor
    implements GenericDescriptor,
    Comparable<FieldDescriptor>,
    FieldSet.FieldDescriptorLite<FieldDescriptor> {
        private static final WireFormat.FieldType[] table = WireFormat.FieldType.values();
        private final int index;
        private DescriptorProtos.FieldDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor extensionScope;
        private Type type;
        private Descriptor containingType;
        private Descriptor messageType;
        private EnumDescriptor enumType;
        private Object defaultValue;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.FieldDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public int getNumber() {
            return this.proto.getNumber();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        public JavaType getJavaType() {
            return this.type.getJavaType();
        }

        @Override
        public WireFormat.JavaType getLiteJavaType() {
            return this.getLiteType().getJavaType();
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return table[this.type.ordinal()];
        }

        public boolean isRequired() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
        }

        public boolean isOptional() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL;
        }

        @Override
        public boolean isRepeated() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
        }

        @Override
        public boolean isPacked() {
            return this.getOptions().getPacked();
        }

        public boolean isPackable() {
            return this.isRepeated() && this.getLiteType().isPackable();
        }

        public boolean hasDefaultValue() {
            return this.proto.hasDefaultValue();
        }

        public Object getDefaultValue() {
            if (this.getJavaType() == JavaType.MESSAGE) {
                throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field.");
            }
            return this.defaultValue;
        }

        public DescriptorProtos.FieldOptions getOptions() {
            return this.proto.getOptions();
        }

        public boolean isExtension() {
            return this.proto.hasExtendee();
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public Descriptor getExtensionScope() {
            if (!this.isExtension()) {
                throw new UnsupportedOperationException("This field is not an extension.");
            }
            return this.extensionScope;
        }

        public Descriptor getMessageType() {
            if (this.getJavaType() != JavaType.MESSAGE) {
                throw new UnsupportedOperationException("This field is not of message type.");
            }
            return this.messageType;
        }

        public EnumDescriptor getEnumType() {
            if (this.getJavaType() != JavaType.ENUM) {
                throw new UnsupportedOperationException("This field is not of enum type.");
            }
            return this.enumType;
        }

        @Override
        public int compareTo(FieldDescriptor fieldDescriptor) {
            if (fieldDescriptor.containingType != this.containingType) {
                throw new IllegalArgumentException("FieldDescriptors can only be compared to other FieldDescriptors for fields of the same message type.");
            }
            return this.getNumber() - fieldDescriptor.getNumber();
        }

        private FieldDescriptor(DescriptorProtos.FieldDescriptorProto fieldDescriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n, boolean bl) throws DescriptorValidationException {
            this.index = n;
            this.proto = fieldDescriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, fieldDescriptorProto.getName());
            this.file = fileDescriptor;
            if (fieldDescriptorProto.hasType()) {
                this.type = Type.valueOf(fieldDescriptorProto.getType());
            }
            if (this.getNumber() <= 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field numbers must be positive integers.");
            }
            if (fieldDescriptorProto.getOptions().getPacked() && !this.isPackable()) {
                throw new DescriptorValidationException((GenericDescriptor)this, "[packed = true] can only be specified for repeated primitive fields.");
            }
            if (bl) {
                if (!fieldDescriptorProto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee not set for extension field.");
                }
                this.containingType = null;
                this.extensionScope = descriptor != null ? descriptor : null;
            } else {
                if (fieldDescriptorProto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee set for non-extension field.");
                }
                this.containingType = descriptor;
                this.extensionScope = null;
            }
            fileDescriptor.pool.addSymbol(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor;
            if (this.proto.hasExtendee()) {
                genericDescriptor = this.file.pool.lookupSymbol(this.proto.getExtendee(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!(genericDescriptor instanceof Descriptor)) {
                    throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getExtendee() + "\" is not a message type.");
                }
                this.containingType = (Descriptor)genericDescriptor;
                if (!this.getContainingType().isExtensionNumber(this.getNumber())) {
                    throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.getContainingType().getFullName() + "\" does not declare " + this.getNumber() + " as an extension number.");
                }
            }
            if (this.proto.hasTypeName()) {
                genericDescriptor = this.file.pool.lookupSymbol(this.proto.getTypeName(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!this.proto.hasType()) {
                    if (genericDescriptor instanceof Descriptor) {
                        this.type = Type.MESSAGE;
                    } else {
                        if (!(genericDescriptor instanceof EnumDescriptor)) throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not a type.");
                        this.type = Type.ENUM;
                    }
                }
                if (this.getJavaType() == JavaType.MESSAGE) {
                    if (!(genericDescriptor instanceof Descriptor)) {
                        throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not a message type.");
                    }
                    this.messageType = (Descriptor)genericDescriptor;
                    if (this.proto.hasDefaultValue()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "Messages can't have default values.");
                    }
                } else {
                    if (this.getJavaType() != JavaType.ENUM) throw new DescriptorValidationException((GenericDescriptor)this, "Field with primitive type has type_name.");
                    if (!(genericDescriptor instanceof EnumDescriptor)) {
                        throw new DescriptorValidationException((GenericDescriptor)this, '\"' + this.proto.getTypeName() + "\" is not an enum type.");
                    }
                    this.enumType = (EnumDescriptor)genericDescriptor;
                }
            } else if (this.getJavaType() == JavaType.MESSAGE || this.getJavaType() == JavaType.ENUM) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field with message or enum type missing type_name.");
            }
            if (this.proto.hasDefaultValue()) {
                if (this.isRepeated()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "Repeated fields cannot have default values.");
                }
                try {
                    switch (this.getType()) {
                        case INT32: 
                        case SINT32: 
                        case SFIXED32: {
                            this.defaultValue = TextFormat.parseInt32(this.proto.getDefaultValue());
                            break;
                        }
                        case UINT32: 
                        case FIXED32: {
                            this.defaultValue = TextFormat.parseUInt32(this.proto.getDefaultValue());
                            break;
                        }
                        case INT64: 
                        case SINT64: 
                        case SFIXED64: {
                            this.defaultValue = TextFormat.parseInt64(this.proto.getDefaultValue());
                            break;
                        }
                        case UINT64: 
                        case FIXED64: {
                            this.defaultValue = TextFormat.parseUInt64(this.proto.getDefaultValue());
                            break;
                        }
                        case FLOAT: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Float.valueOf(Float.POSITIVE_INFINITY);
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Float.valueOf(Float.NEGATIVE_INFINITY);
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Float.valueOf(Float.NaN);
                                break;
                            }
                            this.defaultValue = Float.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case DOUBLE: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Double.POSITIVE_INFINITY;
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Double.NEGATIVE_INFINITY;
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Double.NaN;
                                break;
                            }
                            this.defaultValue = Double.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case BOOL: {
                            this.defaultValue = Boolean.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case STRING: {
                            this.defaultValue = this.proto.getDefaultValue();
                            break;
                        }
                        case BYTES: {
                            try {
                                this.defaultValue = TextFormat.unescapeBytes(this.proto.getDefaultValue());
                                break;
                            }
                            catch (TextFormat.InvalidEscapeSequenceException invalidEscapeSequenceException) {
                                throw new DescriptorValidationException(this, "Couldn't parse default value: " + invalidEscapeSequenceException.getMessage(), invalidEscapeSequenceException);
                            }
                        }
                        case ENUM: {
                            this.defaultValue = this.enumType.findValueByName(this.proto.getDefaultValue());
                            if (this.defaultValue != null) break;
                            throw new DescriptorValidationException((GenericDescriptor)this, "Unknown enum default value: \"" + this.proto.getDefaultValue() + '\"');
                        }
                        case MESSAGE: 
                        case GROUP: {
                            throw new DescriptorValidationException((GenericDescriptor)this, "Message type had default value.");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DescriptorValidationException(this, "Could not parse default value: \"" + this.proto.getDefaultValue() + '\"', numberFormatException);
                }
            } else if (this.isRepeated()) {
                this.defaultValue = Collections.emptyList();
            } else {
                switch (this.getJavaType()) {
                    case ENUM: {
                        this.defaultValue = this.enumType.getValues().get(0);
                        break;
                    }
                    case MESSAGE: {
                        this.defaultValue = null;
                        break;
                    }
                    default: {
                        this.defaultValue = this.getJavaType().defaultDefault;
                    }
                }
            }
            if (!this.isExtension()) {
                this.file.pool.addFieldByNumber(this);
            }
            if (this.containingType == null || !this.containingType.getOptions().getMessageSetWireFormat()) return;
            if (!this.isExtension()) throw new DescriptorValidationException((GenericDescriptor)this, "MessageSets cannot have fields, only extensions.");
            if (this.isOptional() && this.getType() == Type.MESSAGE) return;
            throw new DescriptorValidationException((GenericDescriptor)this, "Extensions of MessageSets must be optional messages.");
        }

        private void setProto(DescriptorProtos.FieldDescriptorProto fieldDescriptorProto) {
            this.proto = fieldDescriptorProto;
        }

        @Override
        public MessageLite.Builder internalMergeFrom(MessageLite.Builder builder, MessageLite messageLite) {
            return ((Message.Builder)builder).mergeFrom((Message)messageLite);
        }

        static {
            if (Type.values().length != DescriptorProtos.FieldDescriptorProto.Type.values().length) {
                throw new RuntimeException("descriptor.proto has a new declared type but Desrciptors.java wasn't updated.");
            }
        }

        public static enum JavaType {
            INT(0),
            LONG(0L),
            FLOAT(Float.valueOf(0.0f)),
            DOUBLE(0.0),
            BOOLEAN(false),
            STRING(""),
            BYTE_STRING(ByteString.EMPTY),
            ENUM(null),
            MESSAGE(null);

            private final Object defaultDefault;

            private JavaType(Object object) {
                this.defaultDefault = object;
            }
        }

        public static enum Type {
            DOUBLE(JavaType.DOUBLE),
            FLOAT(JavaType.FLOAT),
            INT64(JavaType.LONG),
            UINT64(JavaType.LONG),
            INT32(JavaType.INT),
            FIXED64(JavaType.LONG),
            FIXED32(JavaType.INT),
            BOOL(JavaType.BOOLEAN),
            STRING(JavaType.STRING),
            GROUP(JavaType.MESSAGE),
            MESSAGE(JavaType.MESSAGE),
            BYTES(JavaType.BYTE_STRING),
            UINT32(JavaType.INT),
            ENUM(JavaType.ENUM),
            SFIXED32(JavaType.INT),
            SFIXED64(JavaType.LONG),
            SINT32(JavaType.INT),
            SINT64(JavaType.LONG);

            private JavaType javaType;

            private Type(JavaType javaType) {
                this.javaType = javaType;
            }

            public DescriptorProtos.FieldDescriptorProto.Type toProto() {
                return DescriptorProtos.FieldDescriptorProto.Type.valueOf(this.ordinal() + 1);
            }

            public JavaType getJavaType() {
                return this.javaType;
            }

            public static Type valueOf(DescriptorProtos.FieldDescriptorProto.Type type2) {
                return Type.values()[type2.getNumber() - 1];
            }
        }
    }

    public static final class Descriptor
    implements GenericDescriptor {
        private final int index;
        private DescriptorProtos.DescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final Descriptor[] nestedTypes;
        private final EnumDescriptor[] enumTypes;
        private final FieldDescriptor[] fields;
        private final FieldDescriptor[] extensions;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.DescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public DescriptorProtos.MessageOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<Descriptor> getNestedTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.nestedTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public boolean isExtensionNumber(int n) {
            for (DescriptorProtos.DescriptorProto.ExtensionRange extensionRange : this.proto.getExtensionRangeList()) {
                if (extensionRange.getStart() > n || n >= extensionRange.getEnd()) continue;
                return true;
            }
            return false;
        }

        public FieldDescriptor findFieldByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor != null && genericDescriptor instanceof FieldDescriptor) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public FieldDescriptor findFieldByNumber(int n) {
            return (FieldDescriptor)this.file.pool.fieldsByNumber.get(new DescriptorPool.DescriptorIntPair(this, n));
        }

        public Descriptor findNestedTypeByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor != null && genericDescriptor instanceof Descriptor) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String string) {
            GenericDescriptor genericDescriptor = this.file.pool.findSymbol(this.fullName + '.' + string);
            if (genericDescriptor != null && genericDescriptor instanceof EnumDescriptor) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        private Descriptor(DescriptorProtos.DescriptorProto descriptorProto, FileDescriptor fileDescriptor, Descriptor descriptor, int n) throws DescriptorValidationException {
            int n2;
            this.index = n;
            this.proto = descriptorProto;
            this.fullName = Descriptors.computeFullName(fileDescriptor, descriptor, descriptorProto.getName());
            this.file = fileDescriptor;
            this.containingType = descriptor;
            this.nestedTypes = new Descriptor[descriptorProto.getNestedTypeCount()];
            for (n2 = 0; n2 < descriptorProto.getNestedTypeCount(); ++n2) {
                this.nestedTypes[n2] = new Descriptor(descriptorProto.getNestedType(n2), fileDescriptor, this, n2);
            }
            this.enumTypes = new EnumDescriptor[descriptorProto.getEnumTypeCount()];
            for (n2 = 0; n2 < descriptorProto.getEnumTypeCount(); ++n2) {
                this.enumTypes[n2] = new EnumDescriptor(descriptorProto.getEnumType(n2), fileDescriptor, this, n2);
            }
            this.fields = new FieldDescriptor[descriptorProto.getFieldCount()];
            for (n2 = 0; n2 < descriptorProto.getFieldCount(); ++n2) {
                this.fields[n2] = new FieldDescriptor(descriptorProto.getField(n2), fileDescriptor, this, n2, false);
            }
            this.extensions = new FieldDescriptor[descriptorProto.getExtensionCount()];
            for (n2 = 0; n2 < descriptorProto.getExtensionCount(); ++n2) {
                this.extensions[n2] = new FieldDescriptor(descriptorProto.getExtension(n2), fileDescriptor, this, n2, true);
            }
            fileDescriptor.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor genericDescriptor : this.nestedTypes) {
                genericDescriptor.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.fields) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void setProto(DescriptorProtos.DescriptorProto descriptorProto) {
            int n;
            this.proto = descriptorProto;
            for (n = 0; n < this.nestedTypes.length; ++n) {
                this.nestedTypes[n].setProto(descriptorProto.getNestedType(n));
            }
            for (n = 0; n < this.enumTypes.length; ++n) {
                this.enumTypes[n].setProto(descriptorProto.getEnumType(n));
            }
            for (n = 0; n < this.fields.length; ++n) {
                this.fields[n].setProto(descriptorProto.getField(n));
            }
            for (n = 0; n < this.extensions.length; ++n) {
                this.extensions[n].setProto(descriptorProto.getExtension(n));
            }
        }
    }

    public static final class FileDescriptor {
        private DescriptorProtos.FileDescriptorProto proto;
        private final Descriptor[] messageTypes;
        private final EnumDescriptor[] enumTypes;
        private final ServiceDescriptor[] services;
        private final FieldDescriptor[] extensions;
        private final FileDescriptor[] dependencies;
        private final FileDescriptor[] publicDependencies;
        private final DescriptorPool pool;

        public DescriptorProtos.FileDescriptorProto toProto() {
            return this.proto;
        }

        public String getName() {
            return this.proto.getName();
        }

        public String getPackage() {
            return this.proto.getPackage();
        }

        public DescriptorProtos.FileOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<Descriptor> getMessageTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.messageTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public List<ServiceDescriptor> getServices() {
            return Collections.unmodifiableList(Arrays.asList(this.services));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<FileDescriptor> getDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.dependencies));
        }

        public List<FileDescriptor> getPublicDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.publicDependencies));
        }

        public Descriptor findMessageTypeByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            if (this.getPackage().length() > 0) {
                string = this.getPackage() + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) != null && genericDescriptor instanceof Descriptor && genericDescriptor.getFile() == this) {
                return (Descriptor)genericDescriptor;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            if (this.getPackage().length() > 0) {
                string = this.getPackage() + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) != null && genericDescriptor instanceof EnumDescriptor && genericDescriptor.getFile() == this) {
                return (EnumDescriptor)genericDescriptor;
            }
            return null;
        }

        public ServiceDescriptor findServiceByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            if (this.getPackage().length() > 0) {
                string = this.getPackage() + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) != null && genericDescriptor instanceof ServiceDescriptor && genericDescriptor.getFile() == this) {
                return (ServiceDescriptor)genericDescriptor;
            }
            return null;
        }

        public FieldDescriptor findExtensionByName(String string) {
            GenericDescriptor genericDescriptor;
            if (string.indexOf(46) != -1) {
                return null;
            }
            if (this.getPackage().length() > 0) {
                string = this.getPackage() + '.' + string;
            }
            if ((genericDescriptor = this.pool.findSymbol(string)) != null && genericDescriptor instanceof FieldDescriptor && genericDescriptor.getFile() == this) {
                return (FieldDescriptor)genericDescriptor;
            }
            return null;
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray) throws DescriptorValidationException {
            DescriptorPool descriptorPool = new DescriptorPool(fileDescriptorArray);
            FileDescriptor fileDescriptor = new FileDescriptor(fileDescriptorProto, fileDescriptorArray, descriptorPool);
            if (fileDescriptorArray.length != fileDescriptorProto.getDependencyCount()) {
                throw new DescriptorValidationException(fileDescriptor, "Dependencies passed to FileDescriptor.buildFrom() don't match those listed in the FileDescriptorProto.");
            }
            for (int i = 0; i < fileDescriptorProto.getDependencyCount(); ++i) {
                if (fileDescriptorArray[i].getName().equals(fileDescriptorProto.getDependency(i))) continue;
                throw new DescriptorValidationException(fileDescriptor, "Dependencies passed to FileDescriptor.buildFrom() don't match those listed in the FileDescriptorProto.");
            }
            fileDescriptor.crossLink();
            return fileDescriptor;
        }

        public static void internalBuildGeneratedFileFrom(String[] stringArray, FileDescriptor[] fileDescriptorArray, InternalDescriptorAssigner internalDescriptorAssigner) {
            FileDescriptor fileDescriptor;
            DescriptorProtos.FileDescriptorProto fileDescriptorProto;
            byte[] byArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (String descriptorValidationException : stringArray) {
                stringBuilder.append(descriptorValidationException);
            }
            try {
                byArray = stringBuilder.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException fileDescriptorProto2) {
                throw new RuntimeException("Standard encoding ISO-8859-1 not supported by JVM.", fileDescriptorProto2);
            }
            try {
                fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray);
            }
            catch (InvalidProtocolBufferException fileDescriptor2) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", fileDescriptor2);
            }
            try {
                fileDescriptor = FileDescriptor.buildFrom(fileDescriptorProto, fileDescriptorArray);
            }
            catch (DescriptorValidationException descriptorValidationException) {
                throw new IllegalArgumentException("Invalid embedded descriptor for \"" + fileDescriptorProto.getName() + "\".", descriptorValidationException);
            }
            ExtensionRegistry extensionRegistry = internalDescriptorAssigner.assignDescriptors(fileDescriptor);
            if (extensionRegistry != null) {
                try {
                    fileDescriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom(byArray, (ExtensionRegistryLite)extensionRegistry);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", invalidProtocolBufferException);
                }
                fileDescriptor.setProto(fileDescriptorProto);
            }
        }

        private FileDescriptor(DescriptorProtos.FileDescriptorProto fileDescriptorProto, FileDescriptor[] fileDescriptorArray, DescriptorPool descriptorPool) throws DescriptorValidationException {
            int n;
            this.pool = descriptorPool;
            this.proto = fileDescriptorProto;
            this.dependencies = (FileDescriptor[])fileDescriptorArray.clone();
            this.publicDependencies = new FileDescriptor[fileDescriptorProto.getPublicDependencyCount()];
            for (n = 0; n < fileDescriptorProto.getPublicDependencyCount(); ++n) {
                int n2 = fileDescriptorProto.getPublicDependency(n);
                if (n2 < 0 || n2 >= this.dependencies.length) {
                    throw new DescriptorValidationException(this, "Invalid public dependency index.");
                }
                this.publicDependencies[n] = this.dependencies[fileDescriptorProto.getPublicDependency(n)];
            }
            descriptorPool.addPackage(this.getPackage(), this);
            this.messageTypes = new Descriptor[fileDescriptorProto.getMessageTypeCount()];
            for (n = 0; n < fileDescriptorProto.getMessageTypeCount(); ++n) {
                this.messageTypes[n] = new Descriptor(fileDescriptorProto.getMessageType(n), this, null, n);
            }
            this.enumTypes = new EnumDescriptor[fileDescriptorProto.getEnumTypeCount()];
            for (n = 0; n < fileDescriptorProto.getEnumTypeCount(); ++n) {
                this.enumTypes[n] = new EnumDescriptor(fileDescriptorProto.getEnumType(n), this, null, n);
            }
            this.services = new ServiceDescriptor[fileDescriptorProto.getServiceCount()];
            for (n = 0; n < fileDescriptorProto.getServiceCount(); ++n) {
                this.services[n] = new ServiceDescriptor(fileDescriptorProto.getService(n), this, n);
            }
            this.extensions = new FieldDescriptor[fileDescriptorProto.getExtensionCount()];
            for (n = 0; n < fileDescriptorProto.getExtensionCount(); ++n) {
                this.extensions[n] = new FieldDescriptor(fileDescriptorProto.getExtension(n), this, null, n, true);
            }
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor genericDescriptor : this.messageTypes) {
                genericDescriptor.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.services) {
                ((ServiceDescriptor)genericDescriptor).crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void setProto(DescriptorProtos.FileDescriptorProto fileDescriptorProto) {
            int n;
            this.proto = fileDescriptorProto;
            for (n = 0; n < this.messageTypes.length; ++n) {
                this.messageTypes[n].setProto(fileDescriptorProto.getMessageType(n));
            }
            for (n = 0; n < this.enumTypes.length; ++n) {
                this.enumTypes[n].setProto(fileDescriptorProto.getEnumType(n));
            }
            for (n = 0; n < this.services.length; ++n) {
                this.services[n].setProto(fileDescriptorProto.getService(n));
            }
            for (n = 0; n < this.extensions.length; ++n) {
                this.extensions[n].setProto(fileDescriptorProto.getExtension(n));
            }
        }

        public static interface InternalDescriptorAssigner {
            public ExtensionRegistry assignDescriptors(FileDescriptor var1);
        }
    }
}

