/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.services;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.ResponseFetcher;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.Response;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BaseCrawlService;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;

public abstract class BasePaginatedCrawl<T extends BitbucketServerJobMessage, R extends Response>
extends BaseCrawlService<T> {
    protected final ResponseFetcher<BitbucketServerCrawler> responseFetcher;

    public BasePaginatedCrawl(BitbucketServerCrawler crawler, T message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.responseFetcher = new ResponseFetcher<BitbucketServerCrawler>(crawler);
    }

    @Override
    public void execute() throws CrawlerWorkException {
        if (!this.isValidProjectRepoMessage()) {
            return;
        }
        CrawledDataWrappedResponse<R> response = this.processMessage();
        if (((Response)response.getEntity()).hasNext()) {
            BaseCrawlerMessage m = this.newMessage();
            this.crawler.sendCrawlerTaskMessage(m);
        }
    }

    protected abstract BaseCrawlerMessage newMessage() throws CrawlerWorkException;

    protected abstract CrawledDataWrappedResponse<R> processMessage() throws CrawlerWorkException;
}

