/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.components;

import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.io.IOException;
import java.net.URL;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseFetcher<C extends AbstractHttpCrawler> {
    private static final Logger logger = LoggerFactory.getLogger(ResponseFetcher.class);
    private final C crawler;

    public ResponseFetcher(C crawler) {
        this.crawler = crawler;
    }

    private Request buildRequest(URL url) {
        return new Request.Builder().url(url).build();
    }

    private String responseAsContent(URL url) throws CrawlerWorkException {
        return this.crawler.getResponseBody(this.buildRequest(url));
    }

    private String content(URL url) throws CrawlerWorkException {
        return this.responseAsContent(url);
    }

    private <R> R entity(Class<R> clazz, String content) throws IOException {
        return (R)this.crawler.getMapper().readValue(content, clazz);
    }

    public <R> CrawledDataWrappedResponse<R> fetchEntity(Class<R> clazz, URL url) throws CrawlerWorkException {
        String content = null;
        try {
            content = this.content(url);
            return new CrawledDataWrappedResponse<R>(this.entity(clazz, content));
        }
        catch (IOException e) {
            logger.error("Error occurred in fetchEntity for Url - {}, with Response - {}", (Object)url, (Object)content);
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    public <R> CrawledDataWrappedResponse fetch(Class<R> clazz, URL url) throws CrawlerWorkException {
        String content = null;
        try {
            content = this.content(url);
            R entity = this.entity(clazz, content);
            return new CrawledDataWrappedResponse<R>(entity, content);
        }
        catch (IOException e) {
            logger.error("Error occurred in fetch for Url - {}, with Response - {}", (Object)url, (Object)content);
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    public CrawledDataWrappedResponse fetchContent(URL url) throws CrawlerWorkException {
        return new CrawledDataWrappedResponse(this.content(url));
    }
}

