/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.components.prAggregators;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerURLHelper;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.ResponseFetcher;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.prAggregators.PRDataAggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerPullRequestJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Activity;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.ActivitiesResponse;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.net.URL;
import java.util.ArrayList;

public class PullRequestActivitiesAggregator
implements PRDataAggregator {
    private final BitbucketServerPullRequestJobMessage message;
    private final ResponseFetcher<BitbucketServerCrawler> responseFetcher;

    public PullRequestActivitiesAggregator(BitbucketServerPullRequestJobMessage message, BitbucketServerCrawler crawler) {
        this.message = message;
        this.responseFetcher = new ResponseFetcher<BitbucketServerCrawler>(crawler);
    }

    @Override
    public void populate(PullRequest pullRequest) throws CrawlerWorkException {
        CrawledDataWrappedResponse<ActivitiesResponse> response;
        URL url = this.prActivitiesUrl(0, 25);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        while (!CrawledDataWrappedResponse.isEmpty(response = this.responseFetcher.fetchEntity(ActivitiesResponse.class, url))) {
            activities.addAll(response.getEntity().getValues());
            if (CrawledDataWrappedResponse.isLastPage(response)) break;
            url = this.prActivitiesUrl(response.getEntity().getNextPageStart(), 25);
            if (!CrawledDataWrappedResponse.isEmpty(response)) continue;
        }
        pullRequest.setActivities(activities);
    }

    private URL prActivitiesUrl(int offset, int limit) throws CrawlerWorkException {
        return BitbucketServerURLHelper.pullRequestActivitiesURL(this.message.getBaseUrl(), limit, offset, this.message.getProjectKey(), this.message.getRepoSlug(), Long.toString(this.message.getId()));
    }
}

