/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.services;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerTagsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Tag;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.TagsResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.bitbucketserver.repository.LabelRepository;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BasePaginatedCrawl;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters.LabelConverter;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters.UMConverter;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.LabelUM;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketServerTagsCrawl
extends BasePaginatedCrawl<BitbucketServerTagsJobMessage, TagsResponse> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketServerTagsCrawl.class);
    private final UMConverter<LabelUM, Tag> converter;
    private final KeyValueRepository<LabelUM> repository;

    public BitbucketServerTagsCrawl(BitbucketServerCrawler crawler, BitbucketServerTagsJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.converter = new LabelConverter("BitbucketServerPlugin", "v1", "LABEL", "v1").setProject(message.getProjectKey()).setRepo(message.getRepoSlug());
        this.repository = new LabelRepository(crawler, dataMessage);
    }

    @Override
    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketServerJobMessage dm = this.crawler.generateNewMessage(BitbucketServerTagsJobMessage.class, this.message).setLimit(((BitbucketServerTagsJobMessage)this.message).getLimit()).setOffset(((BitbucketServerTagsJobMessage)this.message).nextOffSet());
            return this.createDataMessage(this.message, BitbucketServerTagsJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<TagsResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketServerTagsJobMessage for endpoint", (Object)((BitbucketServerTagsJobMessage)this.message).getBaseUrl());
        CrawledDataWrappedResponse<TagsResponse> response = this.responseFetcher.fetchEntity(TagsResponse.class, ((BitbucketServerTagsJobMessage)this.message).url());
        this.handleResponse(response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<TagsResponse> response) throws CrawlerWorkException {
        Tag tag;
        boolean crawlCommit;
        TagsResponse tagsResponse = response.getEntity();
        logger.debug("Found {} tags in account {}", (Object)tagsResponse.getValues().size(), (Object)this.crawler.getUsername());
        HashSet<String> commits = new HashSet<String>(response.getEntity().getSize());
        Iterator iterator = tagsResponse.getValues().iterator();
        while (iterator.hasNext() && (crawlCommit = this.saveTag(tag = (Tag)iterator.next()))) {
            commits.add(tag.getLatestCommit());
        }
        this.sendCommitDepthJobMessages((BitbucketServerRepoJobMessage)this.message, commits);
    }

    private boolean saveTag(Tag tag) throws CrawlerWorkException {
        logger.debug("Saving label {} in project - {}, repo - {}", new Object[]{tag.getId(), ((BitbucketServerTagsJobMessage)this.message).getProjectKey(), ((BitbucketServerTagsJobMessage)this.message).getRepoSlug()});
        UMWrappedEntity<LabelUM> umWrappedEntity = this.converter.convert(tag);
        return this.repository.save(umWrappedEntity);
    }
}

