/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.transform.aggregators;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerUtil;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.pr.PullRequestUM;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.pr.UrlParts;

public class UrlPartsAggregator
implements Aggregator {
    private String project;
    private String repo;

    public UrlPartsAggregator(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    @Override
    public void populate(PullRequestUM pullRequestUM, PullRequest pullRequest) {
        UrlParts urlParts = new UrlParts();
        urlParts.setRepository(this.repository());
        urlParts.setId(pullRequest.getId().toString());
        urlParts.setRepo(this.repo);
        urlParts.setProject(this.project);
        pullRequestUM.setUrlParts(urlParts);
    }

    private String repository() {
        return BitbucketServerUtil.generateDataId(this.project, this.repo);
    }
}

