/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters;

import com.xebialabs.agatha.crawlers.bitbucketserver.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.aggregators.AdditionalFieldsAggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.aggregators.OthersAggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.aggregators.SystemFieldsAggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.aggregators.UrlPartsAggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters.UMConverter;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.pr.PullRequestUM;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PRConverter
implements UMConverter<PullRequestUM, PullRequest> {
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;
    private String project;
    private String repo;

    public PRConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
    }

    private List<Aggregator> aggregators() {
        return Stream.of(new SystemFieldsAggregator(this.project, this.repo), new UrlPartsAggregator(this.project, this.repo), new OthersAggregator(this.project, this.repo), new AdditionalFieldsAggregator(this.project, this.repo)).collect(Collectors.toList());
    }

    @Override
    public UMWrappedEntity<PullRequestUM> convert(PullRequest entity) {
        PullRequestUM pullRequestUM = new PullRequestUM();
        this.aggregators().forEach(aggregator -> aggregator.populate(pullRequestUM, entity));
        return this.wrappedEntity(entity, pullRequestUM);
    }

    public String getProject() {
        return this.project;
    }

    public PRConverter setProject(String project) {
        this.project = project;
        return this;
    }

    public String getRepo() {
        return this.repo;
    }

    public PRConverter setRepo(String repo) {
        this.repo = repo;
        return this;
    }

    private UMWrappedEntity<PullRequestUM> wrappedEntity(PullRequest entity, PullRequestUM um) {
        return new UMWrappedEntity<PullRequestUM>(this.pluginId, this.pluginVersion, this.type, this.typeVersion, um, DataSourceTypeEnum.PULL_REQUEST).setId(um.getId()).setVersion(entity.getUpdatedDate() + "").wrap();
    }
}

