/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.services;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawlService;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerCommitJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.CommitsCache;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCrawlService<T extends BaseCrawlerMessage>
implements CrawlService {
    private static final Logger logger = LoggerFactory.getLogger(BaseCrawlService.class);
    protected final BitbucketServerCrawler crawler;
    protected final T message;
    protected final BaseCrawlerMessage dataMessage;
    private final Date validDate;
    protected final List<String> projectsFilter;
    protected final List<String> reposFilter;

    public BaseCrawlService(BitbucketServerCrawler crawler, T message, BaseCrawlerMessage dataMessage) {
        this.crawler = crawler;
        this.message = message;
        this.dataMessage = dataMessage;
        this.validDate = crawler.getOldestValidDate();
        this.projectsFilter = this.filter("BITBUCKETSERVER_PROJECTS");
        this.reposFilter = this.filter("BITBUCKETSERVER_REPOS");
    }

    private List<String> filter(String key) {
        return this.crawler.getFilterValues(key);
    }

    protected boolean isValidProjectRepoMessage() {
        return !this.isRepoJobMessage() || this.filterProjectRepo(((BitbucketServerRepoJobMessage)((Object)this.message)).getProjectKey(), ((BitbucketServerRepoJobMessage)((Object)this.message)).getRepoSlug());
    }

    protected boolean isRepoJobMessage() {
        return this.message instanceof BitbucketServerRepoJobMessage;
    }

    protected boolean filterProjectRepo(String key, String slug) {
        return this.filter(this.projectsFilter, key) && this.filter(this.reposFilter, slug);
    }

    private boolean filter(List<String> filterValues, String c) {
        return filterValues.isEmpty() || filterValues.contains(c);
    }

    protected BaseCrawlerMessage createDataMessage(T message, String dataKey, BaseCrawlerMessage dataMessage) {
        dataMessage.setTenantId(message.getTenantId());
        dataMessage.setPluginId(message.getPluginId());
        dataMessage.setMetadata(message.getMetadata());
        dataMessage.setDataSourceDetails(message.getDataSourceDetails());
        dataMessage.setDataKey(dataKey);
        return dataMessage;
    }

    protected boolean isValidCommit(Commit c) {
        return c.getAuthorTimestamp().after(this.validDate);
    }

    protected void sendCommitDepthJobMessages(BitbucketServerRepoJobMessage repoMessage, Set<String> ids) throws CrawlerWorkException {
        logger.debug("Send Commit {} messages in project - {}, repo - {}", new Object[]{ids.size(), repoMessage.getProjectKey(), repoMessage.getRepoSlug()});
        for (String id : ids) {
            if (CommitsCache.isCommitAlreadyRequested(repoMessage.getProjectKey(), repoMessage.getRepoSlug(), id)) continue;
            try {
                BitbucketServerCommitJobMessage dm = this.crawler.generateNewMessage(BitbucketServerCommitJobMessage.class, repoMessage).setId(id);
                this.crawler.sendCrawlerTaskMessage(this.createDataMessage(this.message, BitbucketServerCommitJobMessage.class.getSimpleName(), dm));
                CommitsCache.addRequestedCommit(repoMessage.getProjectKey(), repoMessage.getRepoSlug(), id);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CrawlerWorkException((Throwable)e);
            }
        }
    }
}

