/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.services;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerBranchJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerCommitsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerPullRequestsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerTagsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Repository;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.ReposResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BasePaginatedCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketServerJobCrawl
extends BasePaginatedCrawl<BitbucketServerJobMessage, ReposResponse> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketServerJobMessage.class);

    public BitbucketServerJobCrawl(BitbucketServerCrawler crawler, BitbucketServerJobMessage message) {
        super(crawler, message, null);
    }

    @Override
    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketServerJobMessage bitbucketServerJobMessage = this.crawler.generateNewMessage(BitbucketServerJobMessage.class, this.message).setLimit(((BitbucketServerJobMessage)this.message).getLimit()).setOffset(((BitbucketServerJobMessage)this.message).nextOffSet());
            return this.createDataMessage(this.message, BitbucketServerJobMessage.class.getSimpleName(), bitbucketServerJobMessage);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<ReposResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketServerJobMessage for endpoint {}", (Object)((BitbucketServerJobMessage)this.message).getBaseUrl());
        CrawledDataWrappedResponse<ReposResponse> response = this.responseFetcher.fetchEntity(ReposResponse.class, ((BitbucketServerJobMessage)this.message).url());
        this.handleResponse(response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<ReposResponse> response) throws CrawlerWorkException {
        ReposResponse reposResponse = response.getEntity();
        logger.debug("Found {} repos in account {}", (Object)reposResponse.getValues().size(), (Object)this.crawler.getUsername());
        for (Repository r : reposResponse.getValues()) {
            if (!this.filterProjectRepo(r.getProject().getKey(), r.getSlug())) continue;
            this.sendAllMessages(r);
        }
    }

    private void sendAllMessages(Repository r) throws CrawlerWorkException {
        this.sendMessage(r, BitbucketServerBranchJobMessage.class);
        this.sendMessage(r, BitbucketServerCommitsJobMessage.class);
        this.sendMessage(r, BitbucketServerPullRequestsJobMessage.class);
        this.sendMessage(r, BitbucketServerTagsJobMessage.class);
    }

    private <C extends BitbucketServerRepoJobMessage> void sendMessage(Repository r, Class<C> clazz) throws CrawlerWorkException {
        try {
            BitbucketServerRepoJobMessage dm = this.populateRepoProperties((BitbucketServerRepoJobMessage)((Object)this.crawler.generateNewMessage(clazz, this.message)), r);
            this.crawler.sendCrawlerTaskMessage(this.createDataMessage(this.message, clazz.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private <C extends BitbucketServerRepoJobMessage> C populateRepoProperties(C m, Repository r) {
        m.setRepoId(r.getId()).setRepoName(r.getName()).setRepoSlug(r.getSlug()).setProjectId(r.getProject().getId()).setProjectKey(r.getProject().getKey()).setProjectName(r.getProject().getName());
        return m;
    }
}

