import com.xebialabs.impact.api.DataSourceTypeEnum
import com.xebialabs.impact.wave.scripting.PluginInterface
import CrawledFields
import com.xebialabs.impact.wave.scripting.http.PushDataRequestVM

PluginInterface.setPluginId("CAAgilePlugin")
PluginInterface.setTrace(false)

class CustomFieldsLocalCache {
    volatile static CrawledFields crawledFields
}

class RequestCustomFieldsFromCache {
    boolean force

    RequestCustomFieldsFromCache(boolean force) {
        this.force = force
    }
}

class CachedCustomFields {
    CrawledFields fields

    CachedCustomFields() {
    }

    CachedCustomFields(CrawledFields fields) {
        this.fields = fields
    }
}

class PushDataPackage {
    CrawledFields crawledFields
    TicketUmModels ticketUmModels
}

PluginInterface.pushData(PushDataPackage)
        .mapRequest({ pushDataPackage ->

    if (pushDataPackage.crawledFields) {
        CrawledFields crawledFields = pushDataPackage.crawledFields
        def model = new FieldsUmModel()
        crawledFields.fields.forEach({ field ->
            def umField = new FieldUmModel()
            umField.title.displayName = field.displayName + " (" + field.objectType + ", " + field.workspaceId + ")"
            umField.type = field.fieldType == FieldType.MULTIVALUE ? FieldUmType.multiSelect : FieldUmType.stringNotAnalyzed
            model.fields.put(field.compositeId, umField)
        })
        return new PushDataRequestVM()
                .setArtefactId("fields")
                .setData(Collections.singletonMap("CAAgilePlugin.v1", Collections.singletonMap("FIELDS.v1", Collections.singletonList(model))))
                .setType(DataSourceTypeEnum.FIELDS)
                .setVersion("")
    } else if (pushDataPackage.ticketUmModels) {
        TicketUmModels models = pushDataPackage.ticketUmModels
        return new PushDataRequestVM()
                .setArtefactId(models.id)
                .setVersion(models.artefactVersion)
                .setType(DataSourceTypeEnum.TICKET)
                .setData(Collections.singletonMap("CAAgilePlugin.v1", Collections.singletonMap("TICKET.v1", models.revisions)))
    }
})