/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.ingestion_api;

import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import com.xebialabs.impact.api.PushCrawlerUMDataHelper;
import com.xebialabs.impact.wave.Artefact;
import com.xebialabs.impact.wave.AsyncDataConsumer;
import com.xebialabs.impact.wave.WaveAction;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.ingestion_api.BaseDataIngestionConsumer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIngestionAsyncDataConsumer
extends BaseDataIngestionConsumer
implements AsyncDataConsumer {
    private static final Logger logger = LoggerFactory.getLogger(DataIngestionAsyncDataConsumer.class);

    public DataIngestionAsyncDataConsumer(IngestionApiAsync ingestionApiAsync, String pluginId) {
        super(ingestionApiAsync, pluginId);
    }

    public CompletionStage<Void> apply(WaveAction waveAction, Collection<Artefact> artefacts, WaveSystem waveSystem) {
        if (artefacts.isEmpty()) {
            logger.warn("Empty artefact list submitted by [{}]", (Object)waveAction);
            return CompletableFuture.completedFuture(null);
        }
        return WaveAction.allOf(artefacts.stream().map(artefact -> this.ingestionApiAsync.pushUMData(PushCrawlerUMDataHelper.prepareCrawlerData((BaseCrawlerMessage)waveAction, (Object)artefact.getData(), (DataSourceTypeEnum)artefact.getType(), (String)artefact.getArtefactId(), (String)artefact.getVersion(), (String)AgathaConfiguration.getTenantId(), (String)this.pluginId))).collect(Collectors.toList()));
    }
}

