/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.ComputingGraphBase;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Element {
    private boolean used;
    private String name;
    protected final ComputingGraphBase computingGraph;

    void checkUsed() {
        if (this.used) {
            throw new IllegalStateException("element " + this.name + " is already used");
        }
        this.used = true;
    }

    Element(ComputingGraphBase computingGraph, Element parent, String method, Class<?> firstSource, Class<?> ... sources) {
        this.computingGraph = computingGraph;
        this.name = (parent == null ? "" : parent.name + ".") + method + "(" + Stream.concat(Stream.of(firstSource), Arrays.stream(sources)).filter(Objects::nonNull).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
        if (parent != null) {
            parent.checkUsed();
        }
    }

    Element(ComputingGraphBase computingGraph, String method, Class<?> firstSource, Class<?> ... sources) {
        this(computingGraph, null, method, firstSource, sources);
    }

    public String getName() {
        return this.name;
    }

    public String makeName(String method, Class<?> firstClass, Class<?> ... otherClasses) {
        return this.name + "." + Element.makeGenericName(method, firstClass, otherClasses);
    }

    public static String makeGenericName(String method, Class<?> firstClass, Class<?> ... otherClasses) {
        return method + "(" + Stream.concat(Stream.of(firstClass), Arrays.stream(otherClasses)).filter(Objects::nonNull).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
    }
}

