/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.ComputingGraphBase;
import com.xebialabs.impact.wave.scripting.engine.ContextBase;
import com.xebialabs.impact.wave.scripting.engine.ErrorMessage;
import com.xebialabs.impact.wave.scripting.engine.LogMessage;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Handler<S, C extends ContextBase<C>> {
    protected Class<S> firstSource;
    protected Class<?>[] sources;
    protected Class<?>[] destinations;
    private Function<Supplier<CompletableFuture<Void>>, CompletableFuture<Void>> wrapper;
    private final String name;

    public Handler(String name, Class<S> firstSource, Class<?>[] sources, Class<?>[] destinations) {
        Objects.requireNonNull(firstSource);
        this.firstSource = firstSource;
        this.sources = sources;
        this.destinations = new Class[destinations.length + 2];
        System.arraycopy(destinations, 0, this.destinations, 0, destinations.length);
        this.destinations[destinations.length] = LogMessage.class;
        this.destinations[destinations.length + 1] = ErrorMessage.class;
        this.name = name;
    }

    public abstract CompletableFuture<Void> handle(ComputingGraphBase<?, C> var1, ObjectWrapper<?, C> var2);

    public CompletableFuture<Void> handleWrapped(ComputingGraphBase computingGraph, ObjectWrapper<?, C> object) {
        if (this.wrapper != null) {
            return this.wrapper.apply(() -> this.handle(computingGraph, object));
        }
        return this.handle(computingGraph, object);
    }

    public List<Class<?>> getAllSources() {
        return Stream.concat(Stream.of(this.firstSource), Arrays.stream(this.sources)).collect(Collectors.toList());
    }

    public Class<?>[] getDestinations() {
        return this.destinations;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Handler{firstSource=" + this.firstSource + ", sources=" + Arrays.toString(this.sources) + ", destinations=" + Arrays.toString(this.destinations) + ", name='" + this.name + '\'' + ", " + super.toString() + '}';
    }

    public Class<S> getFirstSource() {
        return this.firstSource;
    }

    public Handler<S, C> setWrapper(Function<Supplier<CompletableFuture<Void>>, CompletableFuture<Void>> wrapper) {
        this.wrapper = wrapper;
        return this;
    }
}

