/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.CapturingHandler;
import com.xebialabs.impact.wave.scripting.engine.Context;
import com.xebialabs.impact.wave.scripting.engine.ContextBase;
import com.xebialabs.impact.wave.scripting.engine.Element;
import com.xebialabs.impact.wave.scripting.engine.ErrorMessage;
import com.xebialabs.impact.wave.scripting.engine.Handler;
import com.xebialabs.impact.wave.scripting.engine.LogMessage;
import com.xebialabs.impact.wave.scripting.engine.MapInterface;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import com.xebialabs.impact.wave.scripting.engine.ReduceGroupBy;
import com.xebialabs.impact.wave.scripting.engine.ReduceInterface;
import com.xebialabs.impact.wave.scripting.engine.ReducingHandler;
import com.xebialabs.impact.wave.scripting.engine.Undefined;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputingGraphBase<G extends ComputingGraphBase, C extends ContextBase<C>> {
    private static final Logger logger = LoggerFactory.getLogger(ComputingGraphBase.class);
    private Map<Class<?>, Set<Class<?>>> forward = new HashMap();
    private Map<Class<?>, Set<Class<?>>> backward = new HashMap();
    private Map<Class<?>, List<ObjectWrapper<Object, C>>> objectsByClass = new HashMap();
    private Map<Class<?>, Handler> handlers = new HashMap();
    private Map<Class<?>, Collection<ReducingHandler<?, C>>> applicableReduceHandlers = new HashMap();
    private AtomicBoolean buildComplete = new AtomicBoolean(false);
    private final Set<String> registeredHandlers = new HashSet<String>();
    private Map<String, Class<?>> allRegisteredClasses = new HashMap();
    private Set<Class<?>> allMentionedGroupByClasses = new HashSet();

    public List<ObjectWrapper<Object, C>> getObjectsByClass(Class<?> c) {
        return this.objectsByClass.computeIfAbsent(c, unused -> new ArrayList());
    }

    private Function<Void, CompletionStage<Void>> collectFutures(C context, ObjectWrapper<?, C> object) {
        return unused -> {
            logger.info("{} handler of {} resolved, {}", new Object[]{object.getRun(), object, context == null ? "no emitter" : "awaiting for " + context.getFutures().size() + " emitted futures to complete"});
            if (context == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.allOf(context.getFutures().toArray(new CompletableFuture[context.getFutures().size()])).thenApply(unused1 -> {
                logger.info("{} all {} emitted from {} resolved", new Object[]{object.getRun(), context.getFutures().size(), object});
                return null;
            });
        };
    }

    public CompletableFuture<Void> handleHandlerResult(ObjectWrapper<?, C> object, C context, Object result, boolean noTriggerReduceCounters) {
        CompletableFuture<Object> resultFuture = result instanceof CompletionStage ? ((CompletionStage)result).toCompletableFuture() : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)resultFuture.thenComposeAsync(unused -> {
            if (context != null) {
                logger.info("{} closing emitter opened by [{}] when processing [{}]", new Object[]{object.getRun(), context.getOpenedBy(), object});
                context.closeEmitter();
            }
            return noTriggerReduceCounters ? CompletableFuture.completedFuture(null) : this.triggerReduceCounters(object, -1);
        })).thenComposeAsync(this.collectFutures(context, object));
    }

    CompletableFuture<Void> triggerReduceCounters(ObjectWrapper<?, C> object, int shift) {
        ArrayList futures = new ArrayList();
        Collection<ReducingHandler<?, C>> reduceHandlers = this.applicableReduceHandlers.get(object.getObject().getClass());
        if (reduceHandlers == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.applyTriggerReduceCounterOneByOne(object, shift, new ArrayList(reduceHandlers), 0);
    }

    private CompletableFuture<Void> applyTriggerReduceCounterOneByOne(ObjectWrapper<?, C> object, int shift, ArrayList<ReducingHandler<?, C>> reducingHandlers, int start) {
        if (start >= reducingHandlers.size()) {
            return CompletableFuture.completedFuture(null);
        }
        logger.info("going to triggerReduceCounters {} for [{}], [{}], [{} of {}] reducers", new Object[]{shift, object, reducingHandlers.get(start).getName(), start, reducingHandlers.size()});
        return this.triggerReduceCounters(object, shift, reducingHandlers.get(start)).thenComposeAsync(unused -> this.applyTriggerReduceCounterOneByOne(object, shift, reducingHandlers, start + 1));
    }

    CompletableFuture<Void> triggerReduceCounters(ObjectWrapper<?, C> object, int shift, ReducingHandler reduceHandler) {
        return reduceHandler.triggerReduceCounters(object.getReducingGroupByValues().get(reduceHandler.getFirstSource()), shift, object);
    }

    public <S> MapInterface<S, C> map(Class<S> c) {
        return new MapInterface(this, c, Element.makeGenericName("map", c, new Class[0]));
    }

    public <S> void capture(Class<S> c, CheckedFunction1<S, Object> f) {
        this.addHandler(new CapturingHandler(c, f));
    }

    public <S> ReduceInterface<S, C> reduce(Class<S> firstClass, Class<?> ... classes) {
        return new ReduceInterface(this, null, "reduce", null, firstClass, classes);
    }

    public void addHandler(Handler<?, C> handler) {
        if (this.buildComplete.get()) {
            throw new IllegalStateException("Build is already complete, you can't add another handler now");
        }
        this.addHandlerInternal(handler);
    }

    private void addHandlerInternal(Handler<?, C> handler) {
        for (Class<?> source : handler.getAllSources()) {
            this.registeredHandlers.add(source.getSimpleName());
            this.allRegisteredClasses.put(source.getSimpleName(), source);
            if (this.handlers.containsKey(source)) {
                throw new IllegalStateException("Handler for [" + source.getName() + "] is already registered by [" + this.getHandlerForClass(source).getName() + "], but now [" + handler.getName() + "] tries to register there again");
            }
            this.handlers.put(source, handler);
        }
        for (Class<?> destination : handler.getDestinations()) {
            this.allRegisteredClasses.put(destination.getSimpleName(), destination);
        }
        this.addLinks(handler.getAllSources(), handler.destinations);
        if (handler instanceof ReducingHandler) {
            Arrays.stream(((ReducingHandler)handler).getGroupBys()).forEach(g -> this.allMentionedGroupByClasses.add(g.getClazz()));
        }
    }

    public void buildComplete() {
        if (this.buildComplete.getAndSet(true)) {
            throw new IllegalStateException("buildComplete already called");
        }
        if (this.getHandlerForClass(LogMessage.class) == null) {
            this.addHandlerInternal(new CapturingHandler(LogMessage.class, (CheckedFunction1 & Serializable)m -> {
                switch (m.getLevel()) {
                    case ERROR: {
                        logger.error(m.getMsg(), m.getArgs());
                        break;
                    }
                    case WARN: {
                        logger.warn(m.getMsg(), m.getArgs());
                        break;
                    }
                    case INFO: {
                        logger.info(m.getMsg(), m.getArgs());
                        break;
                    }
                    case DEBUG: {
                        logger.debug(m.getMsg(), m.getArgs());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown log level: [" + (Object)((Object)m.getLevel()) + "]");
                    }
                }
                return null;
            }));
        }
        if (this.getHandlerForClass(ErrorMessage.class) == null) {
            this.addHandlerInternal(new CapturingHandler(ErrorMessage.class, (CheckedFunction1 & Serializable)m -> {
                throw m.getThrowable();
            }));
        }
        HashSet received = new HashSet();
        HashSet emitted = new HashSet();
        for (Handler handler : this.handlers.values()) {
            received.addAll(handler.getAllSources());
            for (Class<?> destination : handler.getDestinations()) {
                emitted.add(destination);
            }
        }
        emitted.removeAll(received);
        if (!emitted.isEmpty()) {
            throw new IllegalStateException("Following classes were registered as emitted, but do not have handlers for them: [" + emitted.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        }
        for (Map.Entry entry : this.handlers.entrySet()) {
            Handler handler = (Handler)entry.getValue();
            if (!(handler instanceof ReducingHandler)) continue;
            for (Class<?> c : this.bfsBackForClasses(handler.getAllSources())) {
                this.applicableReduceHandlers.computeIfAbsent(c, unused -> new HashSet()).add((ReducingHandler)handler);
            }
        }
        List<Set<ReducingHandler<?, C>>> reduceStages = this.groupReducersIntoStages(this.handlers.values(), this.applicableReduceHandlers);
        for (Class<?> aClass : this.applicableReduceHandlers.keySet()) {
            ArrayList reducingHandlers = new ArrayList(this.applicableReduceHandlers.get(aClass));
            reducingHandlers.sort(Comparator.comparing(h -> {
                for (int i = 0; i < reduceStages.size(); ++i) {
                    if (!((Set)reduceStages.get(i)).contains(h)) continue;
                    return i;
                }
                throw new IllegalStateException("Wrong graph - can't find stage for reducer [" + h + "]");
            }));
            Collections.reverse(reducingHandlers);
            this.applicableReduceHandlers.put(aClass, reducingHandlers);
        }
        for (Class<?> clazz : this.allMentionedGroupByClasses) {
            if (this.getHandlerForClass(clazz) != null) continue;
            throw new IllegalStateException("Class [" + clazz.getSimpleName() + "] was mentioned as .by() but there is no registered handler for it");
        }
    }

    private List<Set<ReducingHandler<?, C>>> groupReducersIntoStages(Collection<Handler> allHandlers, Map<Class<?>, Collection<ReducingHandler<?, C>>> applicableReduceHandlers) {
        ArrayList result = new ArrayList();
        HashSet known = new HashSet();
        Set<ReducingHandler<ReducingHandler<?, C>, C>> allReducers = allHandlers.stream().filter(h -> h instanceof ReducingHandler).map((? super T h) -> (ReducingHandler)h).collect(Collectors.toSet());
        while (!allReducers.isEmpty()) {
            Set<ReducingHandler<?, C>> independentReducers = this.getIndependentReducers(allReducers, applicableReduceHandlers, known);
            if (independentReducers.isEmpty()) {
                throw new IllegalStateException("Impossible reducer dependencies, unable to group reducers into stages");
            }
            result.add(new HashSet(independentReducers));
            known.addAll(independentReducers);
            allReducers.removeAll(independentReducers);
        }
        return result;
    }

    private Set<ReducingHandler<?, C>> getIndependentReducers(Set<ReducingHandler<?, C>> allReducers, Map<Class<?>, Collection<ReducingHandler<?, C>>> applicableReduceHandlers, Set<ReducingHandler<?, C>> known) {
        return allReducers.stream().filter(r -> {
            if (applicableReduceHandlers.containsKey(r.firstSource)) {
                long count = ((Collection)applicableReduceHandlers.get(r.firstSource)).stream().filter(dependantReducer -> dependantReducer != r && !known.contains(dependantReducer)).count();
                return count == 0L;
            }
            return true;
        }).collect(Collectors.toSet());
    }

    private Set<Class<?>> bfsBackForClasses(List<Class<?>> sources) {
        HashSet known = new HashSet(sources);
        HashSet<Class<?>> step = new HashSet(sources);
        while (!step.isEmpty()) {
            HashSet next = new HashSet();
            for (Class clazz : step) {
                Set<Class<?>> c = this.backward.get(clazz);
                if (c == null) continue;
                next.addAll(c);
            }
            next.removeAll(known);
            known.addAll(next);
            step = next;
        }
        return known;
    }

    public CompletableFuture<Void> compute(ObjectWrapper<?, C> ... o) {
        for (ObjectWrapper<?, C> objectWrapper : o) {
            if (objectWrapper.getRun() == null) {
                throw new IllegalStateException("objectWrapper can't be computed without Run: [" + objectWrapper.toString() + "]");
            }
            this.computeReducerGroupByValues(objectWrapper);
            try {
                this.triggerReduceCounters(objectWrapper, 1).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.innerCompute(o);
    }

    private CompletableFuture<Void> innerCompute(ObjectWrapper<?, C> ... objects) {
        if (!this.buildComplete.get()) {
            throw new IllegalStateException("Graph build is not complete");
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (ObjectWrapper object : objects) {
            object.saveIfNecessary(object, new String[0]);
            if (object.getDepthLimit() == 0) continue;
            logger.info("{} innerCompute {} {}", new Object[]{object.getRun(), object, object.getObject()});
            Handler<?, C> handler = this.getHandlerForClass(object.getObject().getClass());
            if (handler == null) {
                throw new IllegalStateException("Handler not registered for class [" + object.getObject().getClass().getName() + "]");
            }
            CompletionStage r = ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(unused -> handler.handleWrapped(this, object))).handle((unused, error) -> error)).thenComposeAsync(error -> {
                if (error != null) {
                    logger.error("", error);
                    if (object.getObject() instanceof ErrorMessage) {
                        throw new IllegalStateException((Throwable)error);
                    }
                    return this.compute(this.wrapObject(new ErrorMessage((Throwable)error), object, "!!!-" + error.getClass().getSimpleName()));
                }
                return CompletableFuture.completedFuture(null);
            });
            futures.add(((CompletableFuture)r).thenApply(unused -> {
                logger.info("{} innerCompute future for {} completed", object.getRun(), (Object)object);
                return null;
            }));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    public Handler<?, C> getHandlerForClass(Class<?> aClass) {
        return this.handlers.get(aClass);
    }

    public C makeContext(ObjectWrapper<?, C> parent, String comment, AtomicInteger counter, List<Object> bucket, Class<?>[] destinations) {
        return this.buildContext(parent, comment, destinations, bucket, counter, objectWrapper -> {
            logger.info("{} emitter: {} -> {}, {}", new Object[]{parent.getRun(), parent.toString(), objectWrapper.toString(), comment});
            this.computeReducerGroupByValues((ObjectWrapper<?, C>)objectWrapper);
            try {
                this.triggerReduceCounters((ObjectWrapper<?, C>)objectWrapper, 1).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
            return CompletableFuture.completedFuture(null).thenComposeAsync(unused -> this.innerCompute((ObjectWrapper<?, C>)objectWrapper));
        });
    }

    private void computeReducerGroupByValues(ObjectWrapper<?, C> objectWrapper) {
        Collection<ReducingHandler<?, C>> reducingHandlers = this.applicableReduceHandlers.get(objectWrapper.getObject().getClass());
        if (reducingHandlers != null) {
            for (ReducingHandler<?, C> reducingHandler : reducingHandlers) {
                ReduceGroupBy[] groupBys = reducingHandler.getGroupBys();
                Objects.requireNonNull(reducingHandler.getFirstSource());
                List reducingGroupByValues = objectWrapper.getReducingGroupByValues().computeIfAbsent(reducingHandler.getFirstSource(), unused -> this.makeNewGroupBysValuesArray(groupBys.length));
                for (int i = 0; i < groupBys.length; ++i) {
                    groupBys[i].computeValueInto(objectWrapper.getObject(), reducingGroupByValues, i);
                }
            }
        }
    }

    public <D> ObjectWrapper<D, C> wrapObject(D object, ObjectWrapper<?, C> parent, String ... name) {
        ObjectWrapper objectWrapper = new ObjectWrapper(object, parent, name.length == 0 ? object.getClass().getSimpleName() : name[0]);
        if (parent != null) {
            parent.getReducingGroupByValues().forEach((k, v) -> {
                Objects.requireNonNull(k);
                objectWrapper.getReducingGroupByValues().put((Class<?>)k, new ArrayList(v));
            });
        }
        return objectWrapper;
    }

    private List<Object> makeNewGroupBysValuesArray(int length) {
        ArrayList<Object> r = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            r.add((Object)Undefined.UNDEFINED);
        }
        return r;
    }

    public boolean shouldBeReduced(ObjectWrapper<?, C> objectWrapper) {
        return this.getHandlerForClass(objectWrapper.getObject().getClass()) instanceof ReducingHandler;
    }

    private void addLinks(List<Class<?>> sources, Class<?>[] destinations) {
        for (Class<?> source : sources) {
            for (Class<?> destination : destinations) {
                this.forward.computeIfAbsent(source, notused -> new HashSet()).add(destination);
                this.backward.computeIfAbsent(destination, notused -> new HashSet()).add(source);
            }
        }
    }

    public void clearRegisteredHandlers() {
        this.registeredHandlers.clear();
    }

    public Set<String> getRegisteredHandlers() {
        return this.registeredHandlers;
    }

    public Map<String, Class<?>> getAllRegisteredClasses() {
        return this.allRegisteredClasses;
    }

    public Collection<Handler> getHandlers() {
        return this.handlers.values();
    }

    protected C buildContext(ObjectWrapper<?, C> openedBy, String comment, Class<?>[] destinations, List<Object> bucket, AtomicInteger counter, Function<ObjectWrapper<?, C>, CompletableFuture<Void>> acceptor) {
        return (C)new Context((ObjectWrapper<?, Context>)openedBy, comment, destinations, bucket, counter, acceptor);
    }
}

