/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.BucketHandlerBinding;
import com.xebialabs.impact.wave.scripting.engine.ComputingGraphBase;
import com.xebialabs.impact.wave.scripting.engine.ContextBase;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import com.xebialabs.impact.wave.scripting.engine.ReducingBuckets;
import com.xebialabs.impact.wave.scripting.engine.ReducingHandler;
import com.xebialabs.impact.wave.scripting.engine.Run;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

class ReducerState<C extends ContextBase<C>> {
    private final ComputingGraphBase computingGraph;
    private final ReducingHandler<?, C> reducingHandler;
    private final Map<List<Object>, BucketHandlerBinding> bucketHandlerBindingMap = new ConcurrentHashMap<List<Object>, BucketHandlerBinding>();
    private final ReducingBuckets reducingBuckets;
    private Run run;

    ReducerState(ComputingGraphBase computingGraph, ReducingHandler<?, C> reducingHandler, Run run) {
        this.computingGraph = computingGraph;
        this.reducingHandler = reducingHandler;
        this.run = run;
        this.reducingBuckets = new ReducingBuckets(this::finish, run, reducingHandler.getName());
    }

    private CompletableFuture<Void> finish(List<Object> objects, ObjectWrapper<?, C> objectWrapper) {
        return this.reducingHandler.finish(objects, this.bucketHandlerBindingMap.get(objects), objectWrapper);
    }

    public ComputingGraphBase getComputingGraph() {
        return this.computingGraph;
    }

    public ReducingHandler<?, C> getReducingHandler() {
        return this.reducingHandler;
    }

    public Map<List<Object>, BucketHandlerBinding> getBucketHandlerBindingMap() {
        return this.bucketHandlerBindingMap;
    }

    public ReducingBuckets getReducingBuckets() {
        return this.reducingBuckets;
    }
}

