/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.agatha.logging.AgathaLogger;
import com.xebialabs.impact.api.AckUmMessagesVM;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownRequestVM;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownResponseVM;
import com.xebialabs.impact.api.CrawlerDataSourceDetails;
import com.xebialabs.impact.api.CrawlerJobMetadata;
import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import com.xebialabs.impact.api.CrawlerProbeResultVM;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import com.xebialabs.impact.api.PushCrawlerUMDataHelper;
import com.xebialabs.impact.api.PushCrawlerUMDataResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM;
import com.xebialabs.impact.api.PushProbeUMStatusRequestVM;
import com.xebialabs.impact.api.SetContextKeyRequest;
import com.xebialabs.impact.wave.WaveActionResult;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.scripting.Launch;
import com.xebialabs.impact.wave.scripting.PluginInterface;
import com.xebialabs.impact.wave.scripting.Probe;
import com.xebialabs.impact.wave.scripting.engine.ComputingGraphBase;
import com.xebialabs.impact.wave.scripting.engine.Element;
import com.xebialabs.impact.wave.scripting.engine.ErrorMessage;
import com.xebialabs.impact.wave.scripting.engine.LogMessage;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import com.xebialabs.impact.wave.scripting.http.AckOrNackInterface;
import com.xebialabs.impact.wave.scripting.http.ApiInterfaceWithOrWithoutResponse;
import com.xebialabs.impact.wave.scripting.http.ApiInterfaceWithResponse;
import com.xebialabs.impact.wave.scripting.http.ApiInterfaceWithoutResponse;
import com.xebialabs.impact.wave.scripting.http.ApiRouterFunction;
import com.xebialabs.impact.wave.scripting.http.PushDataRequestVM;
import com.xebialabs.impact.wave.scripting.http.RequestInterface;
import com.xebialabs.impact.wave.scripting.http.WaveContext;
import com.xebialabs.impact.wave.scripting.http.signals.ContextKeysSent;
import com.xebialabs.impact.wave.scripting.http.signals.DataSent;
import com.xebialabs.impact.wave.scripting.http.signals.Finish;
import com.xebialabs.impact.wave.scripting.http.signals.InitAckOrNackReducer;
import com.xebialabs.impact.wave.scripting.http.signals.InitContextKeyReducer;
import com.xebialabs.impact.wave.scripting.http.signals.InitDataReducer;
import com.xebialabs.impact.wave.scripting.http.signals.InitMessageReducer;
import com.xebialabs.impact.wave.scripting.http.signals.MessagesSent;
import com.xebialabs.impact.wave.scripting.http.signals.NoMoreContextKeys;
import com.xebialabs.impact.wave.scripting.http.signals.NoMoreData;
import com.xebialabs.impact.wave.scripting.http.signals.NoMoreMessages;
import com.xebialabs.impact.wave.scripting.http.signals.OverrideAckOrNackAction;
import com.xebialabs.impact.wave.scripting.http.signals.RawData;
import com.xebialabs.impact.wave.scripting.um.Other;
import com.xebialabs.impact.wave.scripting.um.UmModel;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestComputingGraph
extends ComputingGraphBase<RequestComputingGraph, WaveContext> {
    private static final Logger logger = LoggerFactory.getLogger(RequestComputingGraph.class);
    private final WaveSystem waveSystem;
    private final IngestionApiAsync ingestionApi;
    private final AgathaLogger agathaLogger;
    private final ObjectMapper objectMapper;
    private String pluginId = "";
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public RequestComputingGraph(WaveSystem waveSystem, IngestionApiAsync ingestionApi, AgathaLogger agathaLogger, ObjectMapper objectMapper) {
        this.waveSystem = waveSystem;
        this.ingestionApi = ingestionApi;
        this.agathaLogger = agathaLogger;
        this.objectMapper = objectMapper;
        this.reduce(RawData.class, MessagesSent.class, InitMessageReducer.class).into(NoMoreMessages.class).via(stream -> {
            ArrayList rawData = new ArrayList();
            stream.get(rawData::add);
            stream.onFinish((CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> stream.emit(new NoMoreMessages().setRawData(rawData)));
        });
        this.reduce(DataSent.class, InitDataReducer.class).into(NoMoreData.class).via(stream -> stream.onFinish((CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> stream.emit(new NoMoreData())));
        this.reduce(ContextKeysSent.class, InitContextKeyReducer.class).into(NoMoreContextKeys.class).via(stream -> stream.onFinish((CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> stream.emit(new NoMoreContextKeys())));
        this.reduce(OverrideAckOrNackAction.class, InitAckOrNackReducer.class, NoMoreContextKeys.class).by(CrawlerMessageWithCredentials.class, (CheckedFunction1 & Serializable)c -> c).into(Finish.class).via(stream -> {
            WaveActionResult.AckOrNack[] action = new WaveActionResult.AckOrNack[]{WaveActionResult.AckOrNack.ACK};
            stream.get((CheckedFunction1 & Serializable)o -> {
                action[0] = o.getAction();
                return action[0];
            });
            stream.onFinish((CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> {
                if (action[0] == WaveActionResult.AckOrNack.NONE) {
                    return CompletableFuture.completedFuture(null);
                }
                CrawlerMessageWithCredentials crawlerMessageWithCredentials = (CrawlerMessageWithCredentials)stream.getBucket().get(0);
                return this.getIngestionApi().ackUmMessages(new AckUmMessagesVM().setMessageIds(Collections.singletonList(crawlerMessageWithCredentials.getMessageId())).setNack(action[0] == WaveActionResult.AckOrNack.NACK).setDataSourceId(crawlerMessageWithCredentials.getDataSourceId()).setNetworkId(AgathaConfiguration.getNetworkId()).setTenantId(AgathaConfiguration.getTenantId()).setPluginId(this.pluginId));
            });
        });
        this.reduce(ErrorMessage.class, new Class[0]).by(CrawlerMessageWithCredentials.class, (CheckedFunction1 & Serializable)c -> c).into(Finish.class).via(stream -> {
            AtomicBoolean gotError = new AtomicBoolean(false);
            stream.get((CheckedFunction1 & Serializable)errorMessage -> {
                logger.error("error: ", errorMessage.getThrowable());
                if (!gotError.getAndSet(true)) {
                    CrawlerMessageWithCredentials crawlerMessageWithCredentials = (CrawlerMessageWithCredentials)stream.getBucket().get(0);
                    BaseCrawlerMessage message = crawlerMessageWithCredentials.getMessage();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    errorMessage.getThrowable().printStackTrace(pw);
                    if (message.getProbeId() != null && message.getProbeId() > 0L) {
                        PushProbeUMStatusRequestVM r = new PushProbeUMStatusRequestVM();
                        r.setPluginId(PluginInterface.getCurrentComputingGraph().getPluginId());
                        r.setTenantId(AgathaConfiguration.getTenantId());
                        r.setProbeId(message.getProbeId().longValue());
                        r.setDataSourceId(crawlerMessageWithCredentials.getDataSourceId());
                        r.setProbeStatus(new CrawlerProbeResultVM().setResults(Collections.singletonList(new ProbeResultMetadataVM().setEndpoint(message.getCredentialsToProbe() != null ? message.getCredentialsToProbe().getEndpoint() : crawlerMessageWithCredentials.getCredentials().getEndpoint()).setUsername("?").setIsSuccess(false).setReason(sw.toString()))));
                        return ingestionApi.pushProbeUmStatus(r).thenComposeAsync(unused -> ingestionApi.ackUmMessages(new AckUmMessagesVM().setTenantId(AgathaConfiguration.getTenantId()).setPluginId(PluginInterface.getCurrentComputingGraph().getPluginId()).setDataSourceId(crawlerMessageWithCredentials.getDataSourceId()).setNack(false).setNetworkId(AgathaConfiguration.getNetworkId()).setMessageIds(Collections.singletonList(crawlerMessageWithCredentials.getMessageId()))));
                    }
                    message.getMetadata().setFailures(message.getMetadata().getFailures() + 1);
                    message.getMetadata().setErrorMessage(sw.toString());
                    return this.getIngestionApi().pushUMMessage(new PushCrawlerUMMessagesRequestVM().setTenantId(AgathaConfiguration.getTenantId()).setPluginId(this.pluginId).setNetworkId(AgathaConfiguration.getNetworkId()).setDataSourceId(crawlerMessageWithCredentials.getDataSourceId()).setDlq(message.getMetadata().getFailures() > 32).setMessages(Collections.singletonList(message))).thenComposeAsync(unused -> this.getIngestionApi().ackUmMessages(new AckUmMessagesVM().setPluginId(this.pluginId).setTenantId(AgathaConfiguration.getTenantId()).setNetworkId(AgathaConfiguration.getNetworkId()).setDataSourceId(crawlerMessageWithCredentials.getDataSourceId()).setNack(false).setMessageIds(Collections.singletonList(crawlerMessageWithCredentials.getMessageId()))));
                }
                return null;
            });
        });
        if (agathaLogger != null) {
            this.reduce(LogMessage.class, new Class[0]).by(CrawlerMessageWithCredentials.class, (CheckedFunction1 & Serializable)c -> c).into(Finish.class).via(stream -> {
                CrawlerMessageWithCredentials crawlerMessageWithCredentials = (CrawlerMessageWithCredentials)stream.getBucket().get(0);
                stream.get((CheckedFunction1 & Serializable)m -> {
                    switch (m.getLevel()) {
                        case ERROR: {
                            agathaLogger.error(crawlerMessageWithCredentials.getMessageId() + " " + m.getMsg(), m.getArgs());
                            break;
                        }
                        case WARN: {
                            agathaLogger.warn(crawlerMessageWithCredentials.getMessageId() + " " + m.getMsg(), m.getArgs());
                            break;
                        }
                        case INFO: {
                            agathaLogger.info(crawlerMessageWithCredentials.getMessageId() + " " + m.getMsg(), m.getArgs());
                            break;
                        }
                        case DEBUG: {
                            agathaLogger.debug(crawlerMessageWithCredentials.getMessageId() + " " + m.getMsg(), m.getArgs());
                        }
                    }
                    return null;
                });
            });
        }
    }

    @Override
    public void buildComplete() {
        Class[] messagesHandled = (Class[])Stream.concat(Stream.of(InitContextKeyReducer.class, InitAckOrNackReducer.class, InitDataReducer.class, InitMessageReducer.class), this.getAllRegisteredClasses().values().stream().filter(BaseCrawlerMessage.class::isAssignableFrom)).toArray(Class[]::new);
        this.map(CrawlerMessageWithCredentials.class).into(messagesHandled).via((CheckedFunction2 & Serializable)(m, ctx) -> {
            ctx.setCrawlerMessageWithCredentials((CrawlerMessageWithCredentials)m);
            Object message = m.getMessage();
            if (m.getMessage().isLaunch()) {
                message = this.objectMapper.convertValue((Object)m.getMessage(), Launch.class);
            } else if (m.getMessage().getProbeId() != null) {
                Probe probe = (Probe)((Object)((Object)((Object)this.objectMapper.convertValue((Object)m.getMessage(), Probe.class))));
                if (probe.getCredentialsToProbe() == null) {
                    probe.setCredentialsToProbe(m.getCredentials());
                }
                message = probe;
            } else {
                String dataKey = m.getMessage().getDataKey();
                if (dataKey == null || dataKey.isEmpty()) {
                    throw new IllegalArgumentException("Got message without dataKey");
                }
                Class<?> clazz = this.classLoader.loadClass(dataKey);
                if (!ctx.isAllowedToEmit(message = this.objectMapper.convertValue(message, clazz))) {
                    throw new IllegalStateException("No handler for message [" + message.getClass().getSimpleName() + "]");
                }
            }
            ctx.emit(new InitContextKeyReducer(), new InitAckOrNackReducer(), new InitDataReducer(), new InitMessageReducer(), message);
            return null;
        });
        this.registerDefaultHandlerForSignal(NoMoreMessages.class);
        this.registerDefaultHandlerForSignal(NoMoreData.class);
        this.registerDefaultHandlerForSignal(NoMoreContextKeys.class);
        this.registerDefaultHandlerForSignal(Finish.class);
        super.buildComplete();
    }

    private void registerDefaultHandlerForSignal(Class<?> aClass) {
        if (this.getHandlerForClass(aClass) == null) {
            this.capture(aClass, (CheckedFunction1 & Serializable)v -> null);
        }
    }

    public <S> RequestInterface<S> request(Class<S> source) {
        return new RequestInterface<S>(source, this);
    }

    public <S> ApiInterfaceWithoutResponse<S, PushCrawlerUMMessagesRequestVM, Void, Void> pushMessages(Class<S> source) {
        return new ApiInterfaceWithoutResponse(".pushMessages(" + source.getSimpleName() + ")", (Class)source, this, (ApiRouterFunction & Serializable)(r, m, signal) -> this.getIngestionApi().pushUMMessage(this.inheritMessageProperties((PushCrawlerUMMessagesRequestVM)r, (CrawlerMessageWithCredentials)m)), Void.class, (Class)MessagesSent.class);
    }

    private PushCrawlerUMMessagesRequestVM inheritMessageProperties(PushCrawlerUMMessagesRequestVM r, CrawlerMessageWithCredentials m) {
        for (BaseCrawlerMessage message : r.getMessages()) {
            message.setMetadata(new CrawlerJobMetadata().setIncremental(m.getMessage().getMetadata().isIncremental()).setRunTimestamp(m.getMessage().getMetadata().getRunTimestamp()));
            message.setTenantId(AgathaConfiguration.getTenantId());
            message.setDataSourceDetails(new CrawlerDataSourceDetails().setDataSourceId(m.getDataSourceId()).setNetworkId(AgathaConfiguration.getNetworkId()));
            message.setDataKey(message.getClass().getName());
        }
        r.setDataSourceId(m.getDataSourceId());
        r.setPluginId(this.pluginId);
        r.setNetworkId(AgathaConfiguration.getNetworkId());
        r.setTenantId(AgathaConfiguration.getTenantId());
        return r;
    }

    public <S> ApiInterfaceWithResponse<S, CheckWhichUMArtefactsAreKnownRequestVM, CheckWhichUMArtefactsAreKnownResponseVM, Void> checkWhichArtefactsAreKnown(Class<S> source) {
        return new ApiInterfaceWithResponse(".checkWhichArtefactsAreKnown(" + source.getSimpleName() + ")", source, this, (ApiRouterFunction & Serializable)(r, m, signal) -> {
            r.setDataSourceId(m.getDataSourceId());
            r.setPluginId(this.pluginId);
            m.setTenantId(AgathaConfiguration.getTenantId());
            return this.getIngestionApi().checkWhichUMArtefactsAreKnown(r);
        }, Void.class, Void.class);
    }

    public <S> ApiInterfaceWithOrWithoutResponse<S, PushDataRequestVM, PushCrawlerUMDataResponseVM, NoMoreMessages> pushData(Class<S> source) {
        return new ApiInterfaceWithOrWithoutResponse(".pushData(" + source.getSimpleName() + ")", source, this, (ApiRouterFunction & Serializable)(r, m, signal) -> {
            List<? extends UmModel> list;
            Map<String, List<? extends UmModel>> map;
            r.setPluginId(this.pluginId);
            if (!(signal == null || r.getData().isEmpty() || (map = r.getData().values().iterator().next()).isEmpty() || (list = map.values().iterator().next()).isEmpty())) {
                UmModel umModel = list.get(0);
                if (!signal.getRawDataInjectedOnce().getAndSet(true)) {
                    if (umModel.getOther() == null) {
                        umModel.setOther(new Other());
                    }
                    umModel.getOther().setRaw(signal.getRawData());
                }
            }
            return this.getIngestionApi().pushUMData(PushCrawlerUMDataHelper.prepareCrawlerData((BaseCrawlerMessage)m.getMessage(), r.getData(), (DataSourceTypeEnum)r.getType(), (String)r.getArtefactId(), (String)r.getVersion(), (String)AgathaConfiguration.getTenantId(), (String)this.pluginId));
        }, NoMoreMessages.class, DataSent.class);
    }

    public <S> ApiInterfaceWithoutResponse<S, SetContextKeyRequest, Void, NoMoreData> sendContextKeyValues(Class<S> source) {
        return new ApiInterfaceWithoutResponse(".sendContextKeyValues(" + source.getSimpleName() + ")", (Class)source, this, (ApiRouterFunction & Serializable)(r, m, signal) -> this.getIngestionApi().sendContextKeyValues(r.setTenantId(AgathaConfiguration.getTenantId()).setPluginId(this.pluginId).setDataSourceId(m.getDataSourceId())), NoMoreData.class, (Class)ContextKeysSent.class);
    }

    public <S> ApiInterfaceWithoutResponse<S, PushProbeUMStatusRequestVM, Void, Void> sendProbeResults(Class<S> source) {
        return new ApiInterfaceWithoutResponse(".sendProbeResults(" + source.getSimpleName() + ")", (Class)source, this, (ApiRouterFunction & Serializable)(r, m, signal) -> {
            for (ProbeResultMetadataVM result : r.getProbeStatus().getResults()) {
                result.setEndpoint(m.getCredentials().getEndpoint());
            }
            r.setProbeId(m.getMessage().getProbeId().longValue());
            r.setDataSourceId(m.getDataSourceId());
            r.setPluginId(this.pluginId);
            r.setTenantId(AgathaConfiguration.getTenantId());
            return this.getIngestionApi().pushProbeUmStatus(r);
        }, Void.class, (Class)Void.class);
    }

    public <S> AckOrNackInterface<S> ackOrNack(Class<S> firstSource, Class<?> ... otherSources) {
        return new AckOrNackInterface<S>(Element.makeGenericName("ackOrNack", firstSource, otherSources), firstSource, otherSources, this);
    }

    public WaveSystem getWaveSystem() {
        return this.waveSystem;
    }

    public IngestionApiAsync getIngestionApi() {
        return this.ingestionApi;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public RequestComputingGraph setPluginId(String pluginId) {
        this.pluginId = pluginId;
        return this;
    }

    public RequestComputingGraph setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    protected WaveContext buildContext(ObjectWrapper<?, WaveContext> openedBy, String comment, Class<?>[] destinations, List<Object> bucket, AtomicInteger counter, Function<ObjectWrapper<?, WaveContext>, CompletableFuture<Void>> acceptor) {
        return new WaveContext(openedBy, comment, destinations, bucket, counter, acceptor);
    }
}

