/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.sandbox;

import akka.util.ByteString;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.xebialabs.impact.wave.scripting.engine.DebuggingPersistencyInterface;
import com.xebialabs.impact.wave.scripting.engine.ErrorMessage;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import com.xebialabs.impact.wave.scripting.engine.SerializedObjectWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class Persistency
implements DebuggingPersistencyInterface {
    private final File folder;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final boolean saveSources;
    private final Map<Class<?>, AtomicInteger> counters = new ConcurrentHashMap();
    private final AtomicInteger classCounter = new AtomicInteger(0);
    private final Map<Class<?>, Integer> classIndexes = new HashMap();

    private AtomicInteger getCounter(Class<?> aClass) {
        return this.counters.computeIfAbsent(aClass, unused -> new AtomicInteger());
    }

    public Persistency(File folder, boolean saveSources) {
        this.folder = folder;
        this.saveSources = saveSources;
        folder.mkdirs();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.objectMapper.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
        try {
            Files.list(folder.toPath()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void save(ObjectWrapper<?, ?> o, Object data, String ... modifiers) {
        if (this.saveSources || o.getPath().getParent() != null) {
            try {
                String fileName = this.formatDepth(o) + o.getObject().getClass().getSimpleName() + "-" + String.format("%03d", this.counters.computeIfAbsent(o.getObject().getClass(), unused -> new AtomicInteger()).incrementAndGet()) + Arrays.stream(modifiers).map(m -> "-" + m).collect(Collectors.joining("")) + ".json";
                File resultFile = new File(this.folder + File.separator + fileName);
                if (data instanceof ObjectWrapper) {
                    ObjectWrapper objectWrapper = (ObjectWrapper)data;
                    if (objectWrapper.getObject() instanceof ErrorMessage) {
                        ErrorMessage error = (ErrorMessage)objectWrapper.getObject();
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        error.getThrowable().printStackTrace(pw);
                        String sStackTrace = sw.toString();
                        Files.write(resultFile.toPath(), sStackTrace.getBytes(), new OpenOption[0]);
                        return;
                    }
                    data = new SerializedObjectWrapper((ObjectWrapper)data);
                }
                this.objectMapper.writeValue(resultFile, data instanceof ByteString ? this.readJson(((ByteString)data).toArray()) : data);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private String formatDepth(ObjectWrapper<?, ?> o) {
        int n = this.classIndexes.computeIfAbsent(o.getObject().getClass(), unused -> this.classCounter.incrementAndGet());
        return String.format("%03d-", n);
    }

    private Object readJson(byte[] json) {
        if (json.length == 0) {
            return "";
        }
        try {
            return this.objectMapper.readValue(json, Object.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Set<String> getKnownOutputs(ObjectWrapper<?, ?> parent) {
        return Arrays.stream((Object[])Objects.requireNonNull(this.folder.listFiles())).map(this::getObjectNameFromFileName).filter(name -> name.endsWith(parent.getPath().getFullPath())).collect(Collectors.toSet());
    }

    private String getObjectNameFromFileName(File file) {
        return file.toPath().getFileName().toString().replaceAll("\\.json$", "");
    }

    @Override
    public void removeObsoleteObjects(Set<String> knownOutputs) {
    }
}

