/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers;

import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.api.IngestionHttpClient;
import com.xebialabs.impact.api.CrawlerResourcesMetrics;
import com.xebialabs.impact.api.PluginRuntimeConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerExecutor {
    public static final int MAX_THREADS = 64;
    private static Logger logger = LoggerFactory.getLogger(CrawlerExecutor.class);
    private List<AbstractCrawler> crawlers = new ArrayList<AbstractCrawler>();
    private ExecutorService executorService;
    private boolean firstStart = true;

    public CrawlerExecutor(Supplier<? extends AbstractCrawler> crawlerSupplier) {
        int threads = AgathaConfiguration.getCrawlerThreads();
        IngestionApi ingestionApi = null;
        String pluginId = null;
        for (int i = 0; i < threads; ++i) {
            AbstractCrawler crawler = crawlerSupplier.get();
            if (ingestionApi == null) {
                ingestionApi = crawler.getIngestionApi();
                pluginId = crawler.getPluginId();
            }
            this.crawlers.add(crawler);
        }
        ScheduledExecutorService scheduledExecutorService = this.collectMetrics(crawlerSupplier, ingestionApi, pluginId);
        this.executorService = Executors.newFixedThreadPool(64);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.info("Got shutdown hook");
            for (AbstractCrawler cr : this.crawlers) {
                cr.stop();
            }
            IngestionHttpClient.shutdown();
            scheduledExecutorService.shutdownNow();
            this.executorService.shutdownNow();
        }));
    }

    private void setThreadsCrawler(Supplier<? extends AbstractCrawler> crawlerSupplier, int n) {
        int currentCrawlersSize = this.crawlers.size();
        if (n == -1 || n == currentCrawlersSize) {
            return;
        }
        int value = Math.max(1, Math.min(n, 64));
        if (value < currentCrawlersSize) {
            for (int i = currentCrawlersSize - 1; i >= value; --i) {
                this.crawlers.get(i).stop();
                this.crawlers.remove(i);
            }
            logger.info("Crawler threads decreased from {} to {}", (Object)currentCrawlersSize, (Object)value);
        } else if (value > currentCrawlersSize) {
            for (int i = currentCrawlersSize; i < value; ++i) {
                AbstractCrawler crawler = crawlerSupplier.get();
                this.executorService.execute(crawler);
                this.crawlers.add(crawler);
            }
            logger.info("Crawler threads increased from {} to {}", (Object)currentCrawlersSize, (Object)value);
        }
    }

    private ScheduledExecutorService collectMetrics(Supplier<? extends AbstractCrawler> crawlerSupplier, IngestionApi ingestionApi, String pluginId) {
        ScheduledExecutorService metricEs = Executors.newSingleThreadScheduledExecutor();
        metricEs.scheduleWithFixedDelay(() -> {
            try {
                CrawlerResourcesMetrics crawlerResourcesMetrics = CrawlerExecutor.getCrawlerResourcesMetrics(pluginId, this.firstStart);
                this.firstStart = false;
                logger.info("Resources metrics {} ", (Object)crawlerResourcesMetrics);
                PluginRuntimeConfig pluginRuntimeConfig = ingestionApi.pushCrawlerResourcesMetrics(crawlerResourcesMetrics);
                this.setThreadsCrawler(crawlerSupplier, pluginRuntimeConfig.getThreadsNumber());
            }
            catch (Exception ex) {
                logger.error("Exception happened during metric collection", (Throwable)ex);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        return metricEs;
    }

    public void execute() {
        this.crawlers.forEach(crawler -> this.executorService.execute((Runnable)crawler));
    }

    private static CrawlerResourcesMetrics getCrawlerResourcesMetrics(String plugin, boolean firstStart) {
        return new CrawlerResourcesMetrics().setPluginId(plugin).setTenantId(AgathaConfiguration.getTenantId()).setNetworkId(AgathaConfiguration.getNetworkId()).setFreeMemory(Runtime.getRuntime().freeMemory()).setMaxMemory(Runtime.getRuntime().maxMemory()).setFirstStart(firstStart).setActiveThreads(Thread.activeCount());
    }
}

