/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.ssl;

import akka.actor.ActorSystem;
import akka.http.javadsl.HttpsConnectionContext;
import com.typesafe.sslconfig.akka.AkkaSSLConfig;
import com.xebialabs.impact.wave.ssl.PassiveTrustManager;
import java.security.SecureRandom;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class HttpsConnectionContextProvider {
    private HttpsConnectionContextProvider() {
    }

    public static HttpsConnectionContext httpsConnectionContext(ActorSystem system) {
        SSLContext context;
        akka.http.scaladsl.HttpsConnectionContext httpsConnectionContext = null;
        try {
            context = SSLContext.getInstance("SSL");
            PassiveTrustManager trustManager = new PassiveTrustManager();
            context.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        AkkaSSLConfig defaultSSLConfig = AkkaSSLConfig.get((ActorSystem)system);
        AkkaSSLConfig badSslConfig = defaultSSLConfig.convertSettings(s -> s.withLoose(s.loose().withDisableSNI(true).withDisableHostnameVerification(true)));
        httpsConnectionContext = HttpsConnectionContext.https((SSLContext)context, Optional.of(badSslConfig), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        return httpsConnectionContext;
    }
}

