/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.http;

import akka.actor.ActorSystem;
import akka.http.javadsl.Http;
import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.HttpResponse;
import akka.japi.function.Function2;
import akka.util.ByteString;
import com.xebialabs.agatha.jsonstreaming.Parser;
import com.xebialabs.impact.wave.scripting.engine.MappingHandler;
import com.xebialabs.impact.wave.scripting.http.RequestComputingGraph;
import com.xebialabs.impact.wave.scripting.http.WaveContext;
import com.xebialabs.impact.wave.scripting.http.signals.RawData;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedFunction4;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestMappingHandler<S>
extends MappingHandler<S, WaveContext> {
    public RequestMappingHandler(String name, Class<S> source, CheckedFunction2<S, WaveContext, HttpRequest> fn, RequestComputingGraph computingGraph, Class<?>[] destinations, CheckedFunction4<S, HttpResponse, Parser, WaveContext, Object> parseFn) {
        super(name + ".parseWith()", source, destinations, (CheckedFunction2 & Serializable)(objectWrapper, ctx) -> {
            HttpRequest httpRequest = (HttpRequest)fn.apply(objectWrapper.getObject(), ctx);
            objectWrapper.saveIfNecessary(httpRequest, "request");
            return Http.get((ActorSystem)computingGraph.getWaveSystem().getSystem()).singleRequest(httpRequest).thenComposeAsync(httpResponse -> {
                Parser parser = (Parser)new Parser().setSkipIndexesInPaths(true);
                objectWrapper.saveIfNecessary(httpResponse, "response");
                try {
                    parseFn.apply(objectWrapper.getObject(), httpResponse, (Object)parser, ctx);
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException(throwable);
                }
                Object[] raw = new Object[]{null};
                parser.onArray(path -> {
                    raw[0] = new ArrayList();
                    parser.fillList((List)raw[0]);
                });
                parser.onObject(path -> {
                    raw[0] = new HashMap();
                    parser.fillMap((Map)raw[0]);
                });
                return httpResponse.entity().getDataBytes().runFold((Object)ByteString.empty(), (Function2 & Serializable)(acc, byteString) -> {
                    parser.write(byteString.toArray());
                    if (objectWrapper.getDebuggingPersistencyInterface() != null) {
                        return acc.concat(byteString);
                    }
                    return acc;
                }, computingGraph.getWaveSystem().getMaterializer()).whenComplete((r, e) -> {
                    objectWrapper.saveIfNecessary(r, "content");
                    ctx.emit(new RawData().setData(raw[0]).setUrl(httpRequest.getUri().toString()));
                    try {
                        parser.close();
                    }
                    catch (IOException e1) {
                        throw new IllegalStateException((Throwable)e);
                    }
                });
            });
        });
    }
}

