/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.Run;
import com.xebialabs.impact.wave.scripting.engine.Undefined;
import io.vavr.CheckedFunction2;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReducingBuckets<T> {
    private static final Logger logger = LoggerFactory.getLogger(ReducingBuckets.class);
    private final Map<List<Object>, AtomicInteger> buckets = new ConcurrentHashMap<List<Object>, AtomicInteger>();
    private final Set<List<Object>> seen = new HashSet<List<Object>>();
    private final Set<List<Object>> zeroBuckets = new HashSet<List<Object>>();
    private final CheckedFunction2<List<Object>, T, CompletableFuture<Void>> reducer;
    private final String name;
    private final Run run;

    public ReducingBuckets(CheckedFunction2<List<Object>, T, CompletableFuture<Void>> reducer, Run run, String name) {
        this.reducer = reducer;
        this.run = run;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> triggerCounters(List<Object> values, int shift, T t) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        logger.info("{} going to synchronize", (Object)Thread.currentThread().getName());
        ReducingBuckets reducingBuckets = this;
        synchronized (reducingBuckets) {
            logger.info("{} synchronized", (Object)Thread.currentThread().getName());
            int value = this.buckets.computeIfAbsent(new ArrayList<Object>(values), unused -> new AtomicInteger(0)).addAndGet(shift);
            logger.info("{} triggerCounters [{}] {} {} {} {} => {}", new Object[]{this.name, this.run, Thread.currentThread().getName(), t, values, shift, value});
            if (value < 0) {
                String msg = "bucket value gone below zero for [" + values.toString() + "], [" + t + "]";
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
            if (value == 1 && shift == 1) {
                if (this.seen.contains(value)) {
                    String msg = "bucket restart detected for [" + values.toString() + "], [" + t + "]";
                    logger.error(msg);
                    throw new IllegalStateException(msg);
                }
                logger.info("{} starting bucket [{}] by [{}]", new Object[]{this.run, values, t});
                this.seen.add(values);
            }
            if (value == 0) {
                this.zeroBuckets.add(values);
                CompletableFuture<Void> completableFuture = this.tryLaunch(values, t, false);
                if (completableFuture != null) {
                    futures.add(completableFuture);
                }
                if (this.hasUndefined(values)) {
                    for (List<Object> zeroBucket : new ArrayList<List<Object>>(this.zeroBuckets)) {
                        CompletableFuture<Void> completableFuture1;
                        if (!this.overlaps(values, zeroBucket) || (completableFuture1 = this.tryLaunch(zeroBucket, t, true)) == null) continue;
                        futures.add(completableFuture1);
                    }
                }
            } else {
                this.zeroBuckets.remove(values);
            }
        }
        logger.info("{} unsynchronized", (Object)Thread.currentThread().getName());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private boolean overlaps(List<Object> undefined, List<Object> zeroBucket) {
        for (int i = 0; i < undefined.size(); ++i) {
            if (undefined.get(i) == Undefined.UNDEFINED || undefined.get(i) == zeroBucket.get(i)) continue;
            return false;
        }
        return true;
    }

    private boolean hasUndefined(List<Object> values) {
        for (Object value : values) {
            if (value != Undefined.UNDEFINED) continue;
            return true;
        }
        return false;
    }

    private CompletableFuture<Void> tryLaunch(List<Object> values, T t, boolean triggeredByUndefined) {
        if (!this.hasLimitingUndefinedBuckets(values)) {
            logger.info("{} reducing [{}]: [{}] by [{}], {}", new Object[]{this.run, this.name, values, t, triggeredByUndefined ? " triggered by undefined" : "triggered by normal"});
            return this.reduce(values, t);
        }
        logger.info("{} deferring [{}], [{}] by [{}] because undefined overallapping buckets exist", new Object[]{this.run, this.name, values, t});
        return null;
    }

    private boolean hasLimitingUndefinedBuckets(List<Object> values) {
        int size = 1 << values.size();
        for (int i = 1; i < size; ++i) {
            List<Object> tweakedValues = this.undefineAccordingToMask(values, i);
            AtomicInteger count = this.buckets.get(tweakedValues);
            if (count == null || count.get() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<Object> undefineAccordingToMask(List<Object> values, int i) {
        ArrayList<Object> copy = new ArrayList<Object>(values);
        int j = 0;
        while (i > 0) {
            if (i % 2 == 1) {
                copy.set(j, (Object)Undefined.UNDEFINED);
            }
            i >>= 1;
            ++j;
        }
        return copy;
    }

    private CompletableFuture<Void> reduce(List<Object> values, T t) {
        this.buckets.remove(values);
        this.zeroBuckets.remove(values);
        try {
            return CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
                try {
                    return (CompletionStage)this.reducer.apply((Object)values, t);
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException(throwable);
                }
            });
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }
}

