/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkinscommons;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkinscommons.messages.JenkinsJobMessage;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.shared.utils.ProbeUtils;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJenkinsCrawler
extends AbstractHttpCrawler {
    private static final Logger logger = LoggerFactory.getLogger(BaseJenkinsCrawler.class);

    public BaseJenkinsCrawler(String pluginId) {
        super(pluginId, AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD);
    }

    public BaseJenkinsCrawler(String pluginId, Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super(pluginId, AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD, ingestionApiProvider);
    }

    protected ObjectMapper createMapper() {
        ObjectMapper mapper = super.createMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    protected <C extends BaseJenkinsCrawler> CrawlerJobResult crawlItem(CrawlResolver<C> crawlResolver, C crawler, CrawlerJobWrapper crawlerJob) {
        try {
            CrawlService crawl = crawlResolver.resolve(crawler, crawlerJob);
            crawl.execute();
            return CrawlerJobResult.success();
        }
        catch (CrawlerWorkException e) {
            return CrawlerJobResult.fail((String)e.getMessage());
        }
    }

    protected ProbeResultMetadataVM probe(CrawlerJobWrapper crawlerJob) {
        Request request;
        ProbeResultMetadataVM result = new ProbeResultMetadataVM().setUsername(this.username).setEndpoint(this.endpoint.toString());
        try {
            request = new Request.Builder().url(new URL(this.getEndpoint(), "api/json?tree=nodeName")).build();
        }
        catch (MalformedURLException e) {
            logger.warn("Cannot construct Jenkins probe URL!");
            return result.setSuccess(false).setReason(e.getMessage());
        }
        ProbeUtils.BasicProbeResult basicProbeResult = ProbeUtils.basicProbe((Request)request, (OkHttpClient)((OkHttpClient)this.getClient()));
        result.setReason(basicProbeResult.getResult());
        if (basicProbeResult.isSuccess()) {
            logger.warn("Jenkins probe was successful for user: {}", (Object)this.username);
            result.setSuccess(true);
        } else {
            logger.warn("Jenkins probe was not successful for user: {}", (Object)this.username);
            result.setSuccess(false);
        }
        return result;
    }

    public <V extends JenkinsJobMessage> V generateNewMessage(Class<V> cls, JenkinsJobMessage oldMsg) throws IllegalAccessException, InstantiationException {
        JenkinsJobMessage newMsg = (JenkinsJobMessage)super.generateNewMessage(cls, (BaseCrawlerMessage)oldMsg);
        newMsg.setBaseUrl(oldMsg.getBaseUrl());
        newMsg.setUrl(oldMsg.getUrl());
        newMsg.setName(oldMsg.getName());
        return (V)((Object)newMsg);
    }
}

