/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkins;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.CrawlerExecutor;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.jenkins.components.JenkinsCrawlResolverImpl;
import com.xebialabs.agatha.crawlers.jenkinscommons.BaseJenkinsCrawler;
import com.xebialabs.agatha.crawlers.jenkinscommons.messages.JenkinsJobMessage;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsCrawler
extends BaseJenkinsCrawler {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsCrawler.class);
    private final CrawlResolver<JenkinsCrawler> crawlResolver = new JenkinsCrawlResolverImpl();

    public JenkinsCrawler() {
        super("JenkinsPlugin");
    }

    public JenkinsCrawler(Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super("JenkinsPlugin", ingestionApiProvider);
    }

    protected CrawlerJobResult crawlItem(CrawlerJobWrapper crawlerJob) {
        return this.crawlItem(this.crawlResolver, this, crawlerJob);
    }

    public <V extends JenkinsJobMessage> V generateNewMessage(Class<V> cls, JenkinsJobMessage oldMsg) throws IllegalAccessException, InstantiationException {
        JenkinsJobMessage newMsg = super.generateNewMessage(cls, oldMsg);
        newMsg.setBaseUrl(oldMsg.getBaseUrl());
        newMsg.setUrl(oldMsg.getUrl());
        newMsg.setName(oldMsg.getName());
        return (V)newMsg;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error(e.getMessage(), e));
        new CrawlerExecutor(JenkinsCrawler::new).execute();
    }
}

