/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkins.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkins.JenkinsCrawler;
import com.xebialabs.agatha.crawlers.jenkins.messages.JenkinsFolderJobMessage;
import com.xebialabs.agatha.crawlers.jenkins.models.JenkinsBaseEntity;
import com.xebialabs.agatha.crawlers.jenkins.models.dtos.FolderResponse;
import com.xebialabs.agatha.crawlers.jenkins.services.JenkinsBaseCrawl;
import com.xebialabs.agatha.crawlers.jenkins.services.JenkinsJobCrawl;
import com.xebialabs.agatha.crawlers.jenkinscommons.JenkinsURLHelper;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsFolderJobCrawl
extends JenkinsBaseCrawl<JenkinsFolderJobMessage, FolderResponse> {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsJobCrawl.class);

    public JenkinsFolderJobCrawl(JenkinsCrawler crawler, JenkinsFolderJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    protected CrawledDataWrappedResponse<FolderResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process JenkinsFolderJobMessage for endpoint {}", (Object)((JenkinsFolderJobMessage)this.message).getUrl());
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(FolderResponse.class, JenkinsURLHelper.apiUrl((String)((JenkinsFolderJobMessage)this.message).getUrl(), (String)"api/json?tree=name,jobs[name,url]"));
        this.handleResponse((CrawledDataWrappedResponse<FolderResponse>)response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<FolderResponse> response) throws CrawlerWorkException {
        for (JenkinsBaseEntity job : ((FolderResponse)response.getEntity()).getJobs()) {
            this.sendNextMessage(job);
        }
    }
}

