/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha;

import com.xebialabs.agatha.AgathaConfigurationException;
import java.util.HashMap;
import java.util.Map;

public enum AgathaConfiguration {
    INSTANCE;

    public static final String PREFIX = "XLINSIGHT_";
    public static final String DEFAULT_SPARK_WORKER_MEMORY = "4G";
    public static final String DEFAULT_CRAWL_YEARS_BACK = "2";
    public static final String DEFAULT_INGESTION_HOST = "localhost";
    public static final String DEFAULT_INGESTION_PORT = "7565";
    public static final String DEFAULT_INGESTION_REST_HOST = "localhost";
    public static final String DEFAULT_INGESTION_REST_PORT = "8081";
    public static final String DEFAULT_CRAWLER_SLEEP_MS = "500";
    public static final String DEFAULT_CRAWLER_RETRY_DELAY_MIN = "3";
    public static final String DEFAULT_CRAWLER_MAX_RETRY = "32";
    public static final String DEFAULT_CRAWLER_THREADS = "1";
    public static final String DEFAULT_DATAPROC_THREADS = "32";
    public static final String DEFAULT_TENANT_ID = "XebiaLabs";
    public static final String DEFAULT_NETWORK_ID = "";
    public static final String DEFAULT_API_USERNAME = "admin";
    public static final String DEFAULT_LOGGING_MODE = "dev";
    public static final String DUMP_QUEUE = "DUMP_QUEUE";
    public static final String MESSAGE_QUEUE_LOCAL_FOLDER = "MESSAGE_QUEUE_LOCAL_FOLDER";
    private HashMap<String, String> environmentVariables;

    public static synchronized Map<String, String> getEnvironmentVariables() {
        if (null == AgathaConfiguration.INSTANCE.environmentVariables) {
            AgathaConfiguration.INSTANCE.environmentVariables = new HashMap();
            Map<String, String> env = System.getenv();
            env.forEach((key, value) -> {
                if (0 == key.indexOf(PREFIX)) {
                    AgathaConfiguration.INSTANCE.environmentVariables.put(key.substring(PREFIX.length()), (String)value);
                }
            });
        }
        return AgathaConfiguration.INSTANCE.environmentVariables;
    }

    public static String getEnvironmentVariable(String key) {
        return AgathaConfiguration.getEnvironmentVariables().getOrDefault(key, null);
    }

    public static String getEnvironmentVariable(String key, String defaultValue) {
        String value = AgathaConfiguration.getEnvironmentVariable(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    protected static String getEnvironmentVariableValueOrComplain(String key) {
        String value = AgathaConfiguration.getEnvironmentVariable(key);
        if (null == value || value.length() == 0) {
            throw new AgathaConfigurationException("Environment variable [XLINSIGHT_" + key + "] is not set or empty");
        }
        return value;
    }

    public static String getLoggingMode() {
        return AgathaConfiguration.getEnvironmentVariable("LOGGING_MODE", DEFAULT_LOGGING_MODE);
    }

    public static String getDefaultApiUsername() {
        return AgathaConfiguration.getEnvironmentVariable("API_USERNAME", DEFAULT_API_USERNAME);
    }

    public static String getDefaultApiPassword() {
        return AgathaConfiguration.getEnvironmentVariableValueOrComplain("API_PASSWORD");
    }

    public static String getIngestionRestHost() {
        return AgathaConfiguration.getEnvironmentVariable("INGESTION_REST_HOST", "localhost");
    }

    public static int getIngestionRestPort() {
        return Integer.parseInt(AgathaConfiguration.getEnvironmentVariable("INGESTION_REST_PORT", DEFAULT_INGESTION_REST_PORT));
    }

    public static String getIngestionHost() {
        return AgathaConfiguration.getEnvironmentVariable("INGESTION_HOST", "localhost");
    }

    public static int getIngestionPort() {
        return Integer.parseInt(AgathaConfiguration.getEnvironmentVariable("INGESTION_PORT", DEFAULT_INGESTION_PORT));
    }

    public static boolean isSelfSignedCertsTrusted() {
        return Boolean.parseBoolean(AgathaConfiguration.getEnvironmentVariable("SELF_SIGNED_TRUSTED", "false"));
    }

    public static String getDefaultIngestionDevCert() {
        return AgathaConfiguration.getEnvironmentVariable("INGESTION_DEV_CERT", "xli-ingestion.pem");
    }

    public static boolean isSelfSignedCertsTrustedWhileCrawling() {
        return Boolean.parseBoolean(AgathaConfiguration.getEnvironmentVariable("SELF_SIGNED_TRUSTED_HTTP_CRAWLER", "false"));
    }

    public static int getCrawlMaxYearsBack() {
        return Integer.parseInt(AgathaConfiguration.getEnvironmentVariable("CRAWL_YEARS_BACK", DEFAULT_CRAWL_YEARS_BACK));
    }

    public static int getCrawlerSleepMs() {
        return Integer.parseInt(AgathaConfiguration.getEnvironmentVariable("CRAWLER_SLEEP_MS", DEFAULT_CRAWLER_SLEEP_MS));
    }

    public static int getCrawlerRetryDelayMin() {
        return Integer.parseInt(AgathaConfiguration.getEnvironmentVariable("CRAWLER_RETRY_DELAY_MIN", DEFAULT_CRAWLER_RETRY_DELAY_MIN));
    }

    public static int getCrawlerMaxRetry() {
        return Integer.parseInt(AgathaConfiguration.getEnvironmentVariable("CRAWLER_MAX_RETRY", "32"));
    }

    public static String getTenantId() {
        return AgathaConfiguration.getEnvironmentVariable("TENANT_ID", DEFAULT_TENANT_ID);
    }

    public static String getNetworkId() {
        return AgathaConfiguration.getEnvironmentVariable("NETWORK_ID", DEFAULT_NETWORK_ID);
    }

    public static int getCrawlerThreads() {
        String threads = AgathaConfiguration.getEnvironmentVariable("CRAWLER_THREADS", DEFAULT_CRAWLER_THREADS);
        if (threads.isEmpty()) {
            return Integer.parseInt(DEFAULT_CRAWLER_THREADS);
        }
        return Integer.parseInt(threads);
    }
}

