/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.AlgorithmChecker;
import com.typesafe.sslconfig.ssl.CompositeCertificateException;
import com.typesafe.sslconfig.ssl.package$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u0017\tI2i\\7q_NLG/\u001a-6ae\"&/^:u\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0002tg2T!!\u0002\u0004\u0002\u0013M\u001cHnY8oM&<'BA\u0004\t\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)2$D\u0001\u0017\u0015\t\u0019qC\u0003\u0002\u00193\u0005\u0019a.\u001a;\u000b\u0003i\tQA[1wCbL!\u0001\b\f\u0003!a+\u0004'\u000f+skN$X*\u00198bO\u0016\u0014\b\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u00115\\Gj\\4hKJ\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003I\u0005\u0012Q\u0002T8hO\u0016\u0014h)Y2u_JL\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u001bQ\u0014Xo\u001d;NC:\fw-\u001a:t!\rA#\u0007\u0006\b\u0003S=r!AK\u0017\u000e\u0003-R!\u0001\f\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013!B:dC2\f\u0017B\u0001\u00192\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AL\u0005\u0003gQ\u00121aU3r\u0015\t\u0001\u0014\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0003A\tGnZ8sSRDWn\u00115fG.,'\u000f\u0005\u00029s5\t!!\u0003\u0002;\u0005\t\u0001\u0012\t\\4pe&$\b.\\\"iK\u000e\\WM\u001d\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\tyz\u0004)\u0011\t\u0003q\u0001AQAH\u001eA\u0002}AQAJ\u001eA\u0002\u001dBQAN\u001eA\u0002]Bqa\u0011\u0001C\u0002\u0013%A)\u0001\u0004m_\u001e<WM]\u000b\u0002\u000bB\u0011\u0001ER\u0005\u0003\u000f\u0006\u0012ABT8EKB\u001cHj\\4hKJDa!\u0013\u0001!\u0002\u0013)\u0015a\u00027pO\u001e,'\u000f\t\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0013O\u0016$\u0018iY2faR,G-S:tk\u0016\u00148\u000fF\u0001N!\rqu*U\u0007\u0002c%\u0011\u0001+\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000bAaY3si*\u0011a\u000bE\u0001\tg\u0016\u001cWO]5us&\u0011\u0001l\u0015\u0002\u00101V\u0002\u0014hQ3si&4\u0017nY1uK\")!\f\u0001C\u00017\u0006\u00112\r[3dW\u000ec\u0017.\u001a8u)J,8\u000f^3e)\rav,\u0019\t\u0003\u001dvK!AX\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0006Af\u0003\r!T\u0001\u0006G\"\f\u0017N\u001c\u0005\u0006Ef\u0003\raY\u0001\tCV$\b\u000eV=qKB\u0011A\r\u001b\b\u0003K\u001a\u0004\"AK\u0019\n\u0005\u001d\f\u0014A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\u0019\t\u000b1\u0004A\u0011A7\u0002%\rDWmY6TKJ4XM\u001d+skN$X\r\u001a\u000b\u00049:|\u0007\"\u00021l\u0001\u0004i\u0005\"\u00022l\u0001\u0004\u0019\u0007\"B9\u0001\t\u0013\u0011\u0018!E<ji\"$&/^:u\u001b\u0006t\u0017mZ3sgR\u00111o\u001e\t\u0004QI\"\bC\u0001\u0015v\u0013\t1HGA\u0005UQJ|w/\u00192mK\")\u0001\u0010\u001da\u0001s\u0006)!\r\\8dWB!aJ\u001f\u000b]\u0013\tY\u0018GA\u0005Gk:\u001cG/[8oc!)Q\u0010\u0001C!}\u0006AAo\\*ue&tw\rF\u0001d\u0001")
public class CompositeX509TrustManager
implements X509TrustManager {
    private final Seq<X509TrustManager> trustManagers;
    private final AlgorithmChecker algorithmChecker;
    private final NoDepsLogger logger;

    private NoDepsLogger logger() {
        return this.logger;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        this.logger().debug("getAcceptedIssuers: ");
        ArrayBuffer certificates = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq<Throwable> exceptionList = this.withTrustManagers((Function1<X509TrustManager, BoxedUnit>)(Function1 & Serializable & scala.Serializable)trustManager -> {
            certificates.appendAll((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trustManager.getAcceptedIssuers())));
            return BoxedUnit.UNIT;
        });
        if (!exceptionList.isEmpty()) {
            String msg = ((Throwable)exceptionList.apply(0)).getMessage();
            throw new CompositeCertificateException(msg, (Throwable[])exceptionList.toArray(ClassTag$.MODULE$.apply(Throwable.class)));
        }
        return (X509Certificate[])certificates.toArray(ClassTag$.MODULE$.apply(X509Certificate.class));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
        this.logger().debug(new StringBuilder(28).append("checkClientTrusted: chain = ").append(package$.MODULE$.debugChain(chain)).toString());
        TrustAnchor anchor = new TrustAnchor(chain[chain.length - 1], null);
        this.logger().debug(new StringBuilder(58).append("checkClientTrusted: checking key size only on root anchor ").append(anchor).toString());
        this.algorithmChecker.checkKeyAlgorithms(anchor.getTrustedCert());
        BooleanRef trusted = BooleanRef.create((boolean)false);
        Seq<Throwable> exceptionList = this.withTrustManagers((Function1<X509TrustManager, BoxedUnit>)(Function1 & Serializable & scala.Serializable)trustManager -> {
            CompositeX509TrustManager.$anonfun$checkClientTrusted$1(this, chain, authType, trusted, trustManager);
            return BoxedUnit.UNIT;
        });
        if (!trusted.elem) {
            String msg = "No trust manager was able to validate this certificate chain.";
            throw new CompositeCertificateException(msg, (Throwable[])exceptionList.toArray(ClassTag$.MODULE$.apply(Throwable.class)));
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
        this.logger().debug(new StringBuilder(41).append("checkServerTrusted: chain = ").append(package$.MODULE$.debugChain(chain)).append(", authType = ").append(authType).toString());
        TrustAnchor anchor = new TrustAnchor(chain[chain.length - 1], null);
        this.logger().debug(new StringBuilder(58).append("checkServerTrusted: checking key size only on root anchor ").append(anchor).toString());
        this.algorithmChecker.checkKeyAlgorithms(anchor.getTrustedCert());
        BooleanRef trusted = BooleanRef.create((boolean)false);
        Seq<Throwable> exceptionList = this.withTrustManagers((Function1<X509TrustManager, BoxedUnit>)(Function1 & Serializable & scala.Serializable)trustManager -> {
            CompositeX509TrustManager.$anonfun$checkServerTrusted$1(this, chain, authType, trusted, trustManager);
            return BoxedUnit.UNIT;
        });
        if (!trusted.elem) {
            String msg = new StringBuilder(80).append("No trust manager was able to validate this certificate chain: # of exceptions = ").append(exceptionList.size()).toString();
            throw new CompositeCertificateException(msg, (Throwable[])exceptionList.toArray(ClassTag$.MODULE$.apply(Throwable.class)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Throwable> withTrustManagers(Function1<X509TrustManager, BoxedUnit> block) {
        void var2_2;
        ArrayBuffer exceptionList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.trustManagers.foreach((Function1 & Serializable & scala.Serializable)trustManager -> {
            CompositeX509TrustManager.$anonfun$withTrustManagers$1(this, block, exceptionList, trustManager);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public String toString() {
        return new StringBuilder(66).append("CompositeX509TrustManager(trustManagers = [").append(this.trustManagers).append("], algorithmChecker = ").append(this.algorithmChecker).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$checkClientTrusted$1(CompositeX509TrustManager $this, X509Certificate[] chain$1, String authType$1, BooleanRef trusted$1, X509TrustManager trustManager) {
        trustManager.checkClientTrusted(chain$1, authType$1);
        $this.logger().debug(new StringBuilder(52).append("checkClientTrusted: trustManager ").append(trustManager).append(" found a match for ").append(package$.MODULE$.debugChain(chain$1)).toString());
        trusted$1.elem = true;
    }

    public static final /* synthetic */ void $anonfun$checkServerTrusted$1(CompositeX509TrustManager $this, X509Certificate[] chain$2, String authType$2, BooleanRef trusted$2, X509TrustManager trustManager) {
        trustManager.checkServerTrusted(chain$2, authType$2);
        $this.logger().debug(new StringBuilder(68).append("checkServerTrusted: trustManager ").append(trustManager).append(" using authType ").append(authType$2).append(" found a match for ").append(package$.MODULE$.debugChain(chain$2).toSeq()).toString());
        trusted$2.elem = true;
    }

    public static final /* synthetic */ void $anonfun$withTrustManagers$1(CompositeX509TrustManager $this, Function1 block$1, ArrayBuffer exceptionList$1, X509TrustManager trustManager) {
        try {
            block$1.apply((Object)trustManager);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof CertPathBuilderException) {
                CertPathBuilderException certPathBuilderException = (CertPathBuilderException)throwable2;
                $this.logger().debug(new StringBuilder(90).append("No path found to certificate: this usually means the CA is not in the trust store. Cause: ").append(certPathBuilderException).toString());
                exceptionList$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{certPathBuilderException}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof GeneralSecurityException) {
                GeneralSecurityException generalSecurityException = (GeneralSecurityException)throwable2;
                $this.logger().debug(new StringBuilder(35).append("General security exception. Cause: ").append(generalSecurityException).toString());
                exceptionList$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{generalSecurityException}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.logger().debug(new StringBuilder(29).append("Unexpected exception! Cause: ").append(e).toString());
                exceptionList$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{e}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public CompositeX509TrustManager(LoggerFactory mkLogger, Seq<X509TrustManager> trustManagers, AlgorithmChecker algorithmChecker) {
        this.trustManagers = trustManagers;
        this.algorithmChecker = algorithmChecker;
        this.logger = mkLogger.apply(this.getClass());
    }
}

