/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.travis.TravisCrawler;
import com.xebialabs.agatha.crawlers.travis.TravisURLHelper;
import com.xebialabs.agatha.crawlers.travis.components.TravisResponseFetcher;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildMessage;
import com.xebialabs.agatha.crawlers.travis.models.Build;
import com.xebialabs.agatha.crawlers.travis.repository.BuildRepository;
import com.xebialabs.agatha.crawlers.travis.services.TravisBaseCrawl;
import com.xebialabs.agatha.crawlers.travis.transform.converters.BuildConverter;
import com.xebialabs.agatha.crawlers.travis.transform.models.BuildUM;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TravisBuildCrawl
extends TravisBaseCrawl<TravisBuildMessage, Build> {
    private static final Logger logger = LoggerFactory.getLogger(TravisBuildCrawl.class);
    private final UMConverter<BuildUM, Build> converter;
    private final KeyValueRepository<BuildUM> repository;

    public TravisBuildCrawl(TravisCrawler crawler, TravisBuildMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new TravisResponseFetcher(crawler));
        this.converter = new BuildConverter("TravisPlugin", "v1", "BUILD", "v1").setOrganization(message.getUserName());
        this.repository = new BuildRepository(crawler, dataMessage);
    }

    @Override
    protected CrawledDataWrappedResponse<Build> processTravisMessage() throws CrawlerWorkException {
        logger.debug("Process TravisBuildMessage for repo - {}, buildid - {} ", (Object)((TravisBuildMessage)this.message).getRepoName(), (Object)((TravisBuildMessage)this.message).getBuildId());
        CrawledDataWrappedResponse response = this.getResponseFetcher().fetchEntity(Build.class, TravisURLHelper.buildUrl(((TravisBuildMessage)this.message).getBaseUrl(), ((TravisBuildMessage)this.message).getSelfUrl()));
        this.handleResponse((Build)response.getEntity());
        return response;
    }

    private void handleResponse(Build entity) throws CrawlerWorkException {
        this.saveBuild(entity);
    }

    private void saveBuild(Build build) throws CrawlerWorkException {
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)build);
        this.repository.save(umWrappedEntity);
    }
}

