/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.KeyStoreBuilder;
import com.typesafe.sslconfig.ssl.KeystoreFormats$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u0017\tAb)\u001b7f\u0005\u0006\u001cX\rZ&fsN#xN]3Ck&dG-\u001a:\u000b\u0005\r!\u0011aA:tY*\u0011QAB\u0001\ngNd7m\u001c8gS\u001eT!a\u0002\u0005\u0002\u0011QL\b/Z:bM\u0016T\u0011!C\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ty1*Z=Ti>\u0014XMQ;jY\u0012,'\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u00031YW-_*u_J,G+\u001f9f!\tI\u0002E\u0004\u0002\u001b=A\u00111DD\u0007\u00029)\u0011QDC\u0001\u0007yI|w\u000e\u001e \n\u0005}q\u0011A\u0002)sK\u0012,g-\u0003\u0002\"E\t11\u000b\u001e:j]\u001eT!a\b\b\t\u0011\u0011\u0002!\u0011!Q\u0001\na\t\u0001BZ5mKB\u000bG\u000f\u001b\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005A\u0001/Y:to>\u0014H\rE\u0002\u000eQ)J!!\u000b\b\u0003\r=\u0003H/[8o!\ri1&L\u0005\u0003Y9\u0011Q!\u0011:sCf\u0004\"!\u0004\u0018\n\u0005=r!\u0001B\"iCJDQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD\u0003B\u001a5kY\u0002\"a\u0005\u0001\t\u000b]\u0001\u0004\u0019\u0001\r\t\u000b\u0011\u0002\u0004\u0019\u0001\r\t\u000b\u0019\u0002\u0004\u0019A\u0014\t\u000ba\u0002A\u0011A\u001d\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0003i\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\u0011M,7-\u001e:jifT\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\tA1*Z=Ti>\u0014X\rC\u0003D\u0001\u0011\u0005A)A\u000bck&dGM\u0012:p[.+\u0017p\u001d;pe\u00164\u0015\u000e\\3\u0015\u0007i*u\tC\u0003G\u0005\u0002\u0007\u0001$A\u0005ti>\u0014X\rV=qK\")\u0001J\u0011a\u0001\u0013\u0006!a-\u001b7f!\tQU*D\u0001L\u0015\tae(\u0001\u0002j_&\u0011aj\u0013\u0002\u0005\r&dW\rC\u0003Q\u0001\u0011\u0005\u0011+\u0001\tsK\u0006$7)\u001a:uS\u001aL7-\u0019;fgR\u0011!+\u0019\t\u0004'b[fB\u0001+W\u001d\tYR+C\u0001\u0010\u0013\t9f\"A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&\u0001C%uKJ\f'\r\\3\u000b\u0005]s\u0001C\u0001/`\u001b\u0005i&B\u00010=\u0003\u0011\u0019WM\u001d;\n\u0005\u0001l&aC\"feRLg-[2bi\u0016DQ\u0001S(A\u0002%\u0003")
public class FileBasedKeyStoreBuilder
implements KeyStoreBuilder {
    private final String keyStoreType;
    private final String filePath;
    private final Option<char[]> password;

    @Override
    public KeyStore build() {
        KeyStore keyStore;
        File file = new File(this.filePath);
        Predef$.MODULE$.require(file.exists(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(31).append("Key store file ").append($this.filePath).append(" does not exist!").toString());
        Predef$.MODULE$.require(file.canRead(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(33).append("Cannot read from key store file ").append($this.filePath).append("!").toString());
        String string = this.keyStoreType;
        if ("PEM".equals(string)) {
            Iterable<Certificate> certs = this.readCertificates(file);
            keyStore = KeystoreFormats$.MODULE$.loadCertificates((TraversableOnce<Certificate>)certs);
        } else {
            keyStore = this.buildFromKeystoreFile(string, file);
        }
        return keyStore;
    }

    public KeyStore buildFromKeystoreFile(String storeType, File file) {
        KeyStore keyStore;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            String storeType2 = this.keyStoreType;
            KeyStore store = KeyStore.getInstance(storeType2);
            store.load(inputStream, (char[])this.password.orNull(Predef$.MODULE$.$conforms()));
            keyStore = store;
        }
        return keyStore;
    }

    public Iterable<Certificate> readCertificates(File file) {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(cf.generateCertificates(bis)).asScala();
    }

    public FileBasedKeyStoreBuilder(String keyStoreType, String filePath, Option<char[]> password) {
        this.keyStoreType = keyStoreType;
        this.filePath = filePath;
        this.password = password;
    }
}

