/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.agatha.crawlers.travis.TravisCrawler;
import com.xebialabs.agatha.crawlers.travis.TravisURLHelper;
import com.xebialabs.agatha.crawlers.travis.components.TravisResponseFetcher;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildsMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisJobMessage;
import com.xebialabs.agatha.crawlers.travis.models.Repository;
import com.xebialabs.agatha.crawlers.travis.models.dtos.ReposResponse;
import com.xebialabs.agatha.crawlers.travis.services.TravisBaseCrawl;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TravisJobCrawl
extends TravisBaseCrawl<TravisJobMessage, ReposResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(TravisJobCrawl.class);
    private final List<String> reposFilter = this.filterFromEnvironment("TRAVIS_REPOS");

    public TravisJobCrawl(TravisCrawler crawler, TravisJobMessage message, BaseCrawlerMessage crawlerDataMessage) {
        super(crawler, message, crawlerDataMessage, new TravisResponseFetcher(crawler));
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            TravisJobMessage dm = ((TravisCrawler)this.crawler).generateNewMessage(TravisJobMessage.class, this.message).setLimit(((TravisJobMessage)this.message).getLimit()).setUrl(this.nextURL);
            return this.createDataMessage(TravisJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<ReposResponse> processTravisMessage() throws CrawlerWorkException {
        logger.debug("Process TravisJobMessage for endpoint - {}", (Object)((TravisCrawler)this.crawler).getEndpoint());
        CrawledDataWrappedResponse response = this.getResponseFetcher().fetchEntity(ReposResponse.class, TravisURLHelper.reposUrl((TravisJobMessage)this.message));
        this.handleResponse((ReposResponse)((Object)response.getEntity()));
        return response;
    }

    private void handleResponse(ReposResponse response) throws CrawlerWorkException {
        if (!response.getRepositories().isEmpty()) {
            List filteredRepos = response.getRepositories().stream().filter(r -> this.filter(this.reposFilter, r.getName())).collect(Collectors.toList());
            logger.debug("Found {} repos in account {}", (Object)filteredRepos.size(), (Object)((TravisJobMessage)this.message).getUserName());
            for (Repository repo : filteredRepos) {
                this.handleRepo(repo);
            }
        }
    }

    private void handleRepo(Repository repo) throws CrawlerWorkException {
        try {
            TravisBuildsMessage dm = this.populateRepoAttributes(((TravisCrawler)this.crawler).generateNewMessage(TravisBuildsMessage.class, this.message), repo);
            ((TravisCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(TravisBuildsMessage.class.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private TravisBuildsMessage populateRepoAttributes(TravisBuildsMessage travisBuildsMessage, Repository repo) {
        travisBuildsMessage.setRepoName(repo.getName()).setRepoId(repo.getId()).setSelfUrl(repo.getSelfUrl());
        return travisBuildsMessage;
    }
}

