/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.jsonstreaming;

import com.xebialabs.agatha.jsonstreaming.DataWindowConsumer;
import java.io.IOException;

public class WindowBuffer {
    final char[] buffer;
    final int bufferSize;
    final int windowSize;
    final DataWindowConsumer fn;
    int bufferLength;
    int position;
    int shiftBuffer;

    public WindowBuffer(int windowSize, DataWindowConsumer fn) {
        this.bufferSize = windowSize * 2;
        this.windowSize = windowSize;
        this.fn = fn;
        this.buffer = new char[this.bufferSize + 1];
        this.reset();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int toCopy = Integer.min(len, this.bufferSize - this.bufferLength);
        System.arraycopy(cbuf, off, this.buffer, this.bufferLength + 1, toCopy);
        this.bufferLength += toCopy;
        if (this.bufferLength >= this.windowSize) {
            this.fn.accept(this.buffer, 1, this.bufferLength, this.position, this.position - this.shiftBuffer == 0, false);
            this.position += this.bufferLength - this.windowSize + 1;
            if (len > toCopy) {
                this.fn.accept(cbuf, off + toCopy - this.windowSize, len - toCopy + this.windowSize, this.position, false, false);
                System.arraycopy(cbuf, off + len - this.windowSize, this.buffer, 0, this.windowSize);
            } else {
                System.arraycopy(this.buffer, this.bufferLength - this.windowSize + 1, this.buffer, 0, this.windowSize);
            }
            this.shiftBuffer = 1;
            this.bufferLength = this.windowSize - 1;
        }
    }

    public void close() throws IOException {
        this.fn.accept(this.buffer, 1 - this.shiftBuffer, Integer.min(this.bufferLength + this.shiftBuffer, this.windowSize), this.position - this.shiftBuffer, this.position - this.shiftBuffer == 0, true);
    }

    public void reset() {
        this.bufferLength = 0;
        this.position = 0;
        this.shiftBuffer = 0;
    }
}

