/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.travis.TravisCrawler;
import com.xebialabs.agatha.crawlers.travis.TravisURLHelper;
import com.xebialabs.agatha.crawlers.travis.components.TravisResponseFetcher;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildJobMessage;
import com.xebialabs.agatha.crawlers.travis.models.Job;
import com.xebialabs.agatha.crawlers.travis.models.Log;
import com.xebialabs.agatha.crawlers.travis.repository.BuildRepository;
import com.xebialabs.agatha.crawlers.travis.services.TravisBaseCrawl;
import com.xebialabs.agatha.crawlers.travis.transform.converters.JobConverter;
import com.xebialabs.agatha.crawlers.travis.transform.models.BuildUM;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TravisBuildJobCrawl
extends TravisBaseCrawl<TravisBuildJobMessage, Job> {
    private static final Logger logger = LoggerFactory.getLogger(TravisBuildJobCrawl.class);
    private final UMConverter<BuildUM, Job> converter;
    private final KeyValueRepository<BuildUM> repository;

    public TravisBuildJobCrawl(TravisCrawler crawler, TravisBuildJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new TravisResponseFetcher(crawler));
        this.converter = new JobConverter("TravisPlugin", "v1", "BUILD", "v1").setOrganization(message.getUserName());
        this.repository = new BuildRepository(crawler, dataMessage);
    }

    @Override
    protected CrawledDataWrappedResponse<Job> processTravisMessage() throws CrawlerWorkException {
        logger.debug("Process TravisBuildJobMessage for repo - {}, buildid - {}, jobId - {}", new Object[]{((TravisBuildJobMessage)this.message).getRepoName(), ((TravisBuildJobMessage)this.message).getBuildId(), ((TravisBuildJobMessage)this.message).getJobId()});
        CrawledDataWrappedResponse response = this.getResponseFetcher().fetchEntity(Job.class, TravisURLHelper.buildUrl(((TravisBuildJobMessage)this.message).getBaseUrl(), ((TravisBuildJobMessage)this.message).getSelfUrl()));
        this.handleResponse((Job)response.getEntity());
        return response;
    }

    private void handleResponse(Job entity) throws CrawlerWorkException {
        this.enrichJob(entity);
        this.saveBuild(entity);
    }

    private void enrichJob(Job entity) throws CrawlerWorkException {
        CrawledDataWrappedResponse response = this.getResponseFetcher().fetchEntity(Log.class, TravisURLHelper.jobLogUrl((TravisBuildJobMessage)this.message));
        entity.setLog((Log)response.getEntity());
    }

    private void saveBuild(Job job) throws CrawlerWorkException {
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)job);
        this.repository.save(umWrappedEntity);
    }
}

