/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.zendesk;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.CrawlerExecutor;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskUrlHelper;
import com.xebialabs.agatha.crawlers.zendesk.components.ZendeskCrawlResolver;
import com.xebialabs.agatha.crawlers.zendesk.messages.ZendeskJobMessage;
import com.xebialabs.agatha.crawlers.zendesk.models.dtos.UserResponse;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import java.io.IOException;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZendeskCrawler
extends AbstractHttpCrawler {
    private static final Logger logger = LoggerFactory.getLogger(ZendeskCrawler.class);
    private final CrawlResolver<ZendeskCrawler> crawlResolver = new ZendeskCrawlResolver();

    public ZendeskCrawler() {
        super("ZendeskPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD);
    }

    public ZendeskCrawler(Function<ObjectMapper, IngestionApi> ingestionApiProvider) {
        super("ZendeskPlugin", AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD, ingestionApiProvider);
    }

    protected ObjectMapper createMapper() {
        ObjectMapper mapper = super.createMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    protected CrawlerJobResult crawlItem(CrawlerJobWrapper crawlerJob) {
        try {
            CrawlService crawl = this.crawlResolver.resolve((AbstractCrawler)this, crawlerJob);
            crawl.execute();
            return CrawlerJobResult.success();
        }
        catch (CrawlerWorkException e) {
            return CrawlerJobResult.fail((String)e.getMessage());
        }
    }

    private Response probeResponse() throws IOException {
        Request request = new Request.Builder().url(ZendeskUrlHelper.probeUrl(this.endpoint)).build();
        return ((OkHttpClient)this.getClient()).newCall(request).execute();
    }

    private boolean isProbeSuccessful(Response response) throws IOException {
        if (!response.isSuccessful()) {
            return false;
        }
        UserResponse parsedResponse = (UserResponse)this.mapper.readValue(response.body().string(), UserResponse.class);
        return parsedResponse.hasAuthenticatedUser(this.username);
    }

    protected ProbeResultMetadataVM probe(CrawlerJobWrapper crawlerJob) {
        ProbeResultMetadataVM resultBuilder = new ProbeResultMetadataVM().setEndpoint(this.endpoint.toString()).setUsername(this.username);
        try {
            Response response = this.probeResponse();
            if (this.isProbeSuccessful(response)) {
                logger.info("Probe success! User with email: {} is authenticated", (Object)this.username);
                return resultBuilder.setSuccess(true);
            }
            logger.warn("Zendesk probe was not successful, User with email: {} could not be authenticated", (Object)this.username);
            return resultBuilder.setSuccess(false).setReason("Status: " + response.code());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return resultBuilder.setSuccess(false).setReason(e.getMessage());
        }
    }

    public <V extends BaseCrawlerMessage> V generateNewMessage(Class<V> cls, BaseCrawlerMessage oldMsg) throws IllegalAccessException, InstantiationException {
        BaseCrawlerMessage v = super.generateNewMessage(cls, oldMsg);
        if (v instanceof ZendeskJobMessage && oldMsg instanceof ZendeskJobMessage) {
            ZendeskJobMessage newMsg = (ZendeskJobMessage)v;
            ZendeskJobMessage old = (ZendeskJobMessage)oldMsg;
            newMsg.setBaseUrl(old.getBaseUrl());
        }
        return (V)v;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error(e.getMessage(), e));
        new CrawlerExecutor(ZendeskCrawler::new).execute();
    }
}

