/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.zendesk.components;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.BaseCrawlFactory;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.zendesk.ZendeskCrawler;
import com.xebialabs.agatha.crawlers.zendesk.messages.ZendeskCustomFieldsMessage;
import com.xebialabs.agatha.crawlers.zendesk.messages.ZendeskTicketMessage;
import com.xebialabs.agatha.crawlers.zendesk.messages.ZendeskTicketsMessage;
import com.xebialabs.agatha.crawlers.zendesk.services.ZendeskCustomFieldsCrawl;
import com.xebialabs.agatha.crawlers.zendesk.services.ZendeskTicketCrawl;
import com.xebialabs.agatha.crawlers.zendesk.services.ZendeskTicketsCrawl;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.io.IOException;

public class ZendeskCrawlFactory
extends BaseCrawlFactory<ZendeskCrawler> {
    private CrawlService ticketsCrawl(ZendeskCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new ZendeskTicketsCrawl(crawler, (ZendeskTicketsMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, ZendeskTicketsMessage.class)), crawlerDataMessage);
    }

    private CrawlService ticketCrawl(ZendeskCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new ZendeskTicketCrawl(crawler, (ZendeskTicketMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, ZendeskTicketMessage.class)), crawlerDataMessage);
    }

    private CrawlService customFieldsCrawl(ZendeskCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new ZendeskCustomFieldsCrawl(crawler, (ZendeskCustomFieldsMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, ZendeskCustomFieldsMessage.class)), crawlerDataMessage);
    }

    public CrawlService getInstance(ZendeskCrawler crawler, BaseCrawlerMessage message) throws CrawlerWorkException {
        CrawlService crawlService;
        try {
            switch (message.getDataKey().toLowerCase()) {
                case "zendeskticketsmessage": {
                    crawlService = this.ticketsCrawl(crawler, message);
                    break;
                }
                case "zendeskticketmessage": {
                    crawlService = this.ticketCrawl(crawler, message);
                    break;
                }
                case "zendeskcustomfieldsmessage": {
                    crawlService = this.customFieldsCrawl(crawler, message);
                    break;
                }
                default: {
                    throw new CrawlerWorkException("No Crawler implementation found.");
                }
            }
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
        return crawlService;
    }
}

