/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.util.Collections;
import org.jline.reader.LineReader;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.utils.AttributedString;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.shell.ExitRequest;
import org.springframework.shell.Input;
import org.springframework.shell.InputProvider;
import org.springframework.shell.Shell;
import org.springframework.shell.jline.ParsedLineInput;
import org.springframework.shell.jline.PromptProvider;

@Order(value=0)
public class InteractiveShellApplicationRunner
implements ApplicationRunner {
    public static final int PRECEDENCE = 0;
    public static final String SPRING_SHELL_INTERACTIVE = "spring.shell.interactive";
    public static final String ENABLED = "enabled";
    public static final String SPRING_SHELL_INTERACTIVE_ENABLED = "spring.shell.interactive.enabled";
    private final LineReader lineReader;
    private final PromptProvider promptProvider;
    private final Parser parser;
    private final Shell shell;
    private final Environment environment;

    public InteractiveShellApplicationRunner(LineReader lineReader, PromptProvider promptProvider, Parser parser, Shell shell, Environment environment) {
        this.lineReader = lineReader;
        this.promptProvider = promptProvider;
        this.parser = parser;
        this.shell = shell;
        this.environment = environment;
    }

    public void run(ApplicationArguments args) throws Exception {
        boolean interactive = this.isEnabled();
        if (interactive) {
            JLineInputProvider inputProvider = new JLineInputProvider(this.lineReader, this.promptProvider);
            this.shell.run(inputProvider);
        }
    }

    public boolean isEnabled() {
        return (Boolean)this.environment.getProperty(SPRING_SHELL_INTERACTIVE_ENABLED, Boolean.TYPE, (Object)true);
    }

    public static void disable(ConfigurableEnvironment environment) {
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("interactive.override", Collections.singletonMap(SPRING_SHELL_INTERACTIVE_ENABLED, "false")));
    }

    public static class JLineInputProvider
    implements InputProvider {
        private final LineReader lineReader;
        private final PromptProvider promptProvider;

        public JLineInputProvider(LineReader lineReader, PromptProvider promptProvider) {
            this.lineReader = lineReader;
            this.promptProvider = promptProvider;
        }

        @Override
        public Input readInput() {
            try {
                AttributedString prompt = this.promptProvider.getPrompt();
                this.lineReader.readLine(prompt.toAnsi(this.lineReader.getTerminal()));
            }
            catch (UserInterruptException e) {
                if (e.getPartialLine().isEmpty()) {
                    throw new ExitRequest(1);
                }
                return Input.EMPTY;
            }
            return new ParsedLineInput(this.lineReader.getParsedLine());
        }
    }
}

