/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.result;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ResolvableType;
import org.springframework.shell.ResultHandler;

public class TypeHierarchyResultHandler
implements ResultHandler<Object> {
    private Map<Class<?>, ResultHandler<?>> resultHandlers = new HashMap();

    @Override
    public void handleResult(Object result) {
        if (result == null) {
            return;
        }
        Class<?> clazz = result.getClass();
        ResultHandler handler = this.getResultHandler(clazz);
        handler.handleResult(result);
    }

    private ResultHandler getResultHandler(Class<?> clazz) {
        ResultHandler handler = this.resultHandlers.get(clazz);
        if (handler != null) {
            return handler;
        }
        for (Class<?> type : clazz.getInterfaces()) {
            handler = this.getResultHandler(type);
            if (handler == null) continue;
            return handler;
        }
        return clazz.getSuperclass() != null ? this.getResultHandler(clazz.getSuperclass()) : null;
    }

    @Autowired
    public void setResultHandlers(Set<ResultHandler<?>> resultHandlers) {
        for (ResultHandler<?> resultHandler : resultHandlers) {
            ResolvableType type = ResolvableType.forInstance(resultHandler).as(ResultHandler.class);
            this.registerHandler(type.resolveGeneric(new int[]{0}), resultHandler);
        }
    }

    private void registerHandler(Class<?> type, ResultHandler<?> resultHandler) {
        ResultHandler<?> previous = this.resultHandlers.put(type, resultHandler);
        if (previous != null) {
            throw new IllegalArgumentException(String.format("Multiple ResultHandlers configured for %s: both %s and %s", type, previous, resultHandler));
        }
    }
}

