/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.metadata.ElementDescriptor;
import org.springframework.core.MethodParameter;
import org.springframework.shell.Utils;

public class ParameterDescription {
    private final MethodParameter parameter;
    private final String type;
    private String formal;
    private Optional<String> defaultValue = Optional.empty();
    private Optional<String> defaultValueWhenFlag = Optional.empty();
    private List<String> keys = Collections.emptyList();
    private boolean mandatoryKey = true;
    private String help = "";
    private ElementDescriptor elementDescriptor;

    public ParameterDescription(MethodParameter parameter, String type) {
        this.parameter = parameter;
        this.type = type;
        this.formal = type;
    }

    public static ParameterDescription outOf(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        return new ParameterDescription(parameter, Utils.unCamelify(type.getSimpleName()));
    }

    public ParameterDescription help(String help) {
        this.help = help;
        return this;
    }

    public boolean mandatoryKey() {
        return this.mandatoryKey;
    }

    public List<String> keys() {
        return this.keys;
    }

    public Optional<String> defaultValue() {
        return this.defaultValue;
    }

    public ParameterDescription defaultValue(String defaultValue) {
        this.defaultValue = Optional.ofNullable(defaultValue);
        return this;
    }

    public ParameterDescription whenFlag(String defaultValue) {
        this.defaultValueWhenFlag = Optional.of(defaultValue);
        return this;
    }

    public ParameterDescription keys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    public ParameterDescription mandatoryKey(boolean mandatoryKey) {
        this.mandatoryKey = mandatoryKey;
        return this;
    }

    public ElementDescriptor elementDescriptor() {
        return this.elementDescriptor;
    }

    public ParameterDescription elementDescriptor(ElementDescriptor descriptor) {
        this.elementDescriptor = descriptor;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String formal() {
        return this.formal;
    }

    public String help() {
        return this.help;
    }

    public Optional<String> defaultValueWhenFlag() {
        return this.defaultValueWhenFlag;
    }

    public ParameterDescription formal(String formal) {
        this.formal = formal;
        return this;
    }

    public String toString() {
        return String.format("%s %s", this.keys.isEmpty() ? "" : this.keys().iterator().next(), this.formal());
    }

    public MethodParameter parameter() {
        return this.parameter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterDescription that = (ParameterDescription)o;
        return this.mandatoryKey == that.mandatoryKey && Objects.equals(this.parameter, that.parameter) && Objects.equals(this.type, that.type) && Objects.equals(this.formal, that.formal) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.defaultValueWhenFlag, that.defaultValueWhenFlag) && Objects.equals(this.keys, that.keys) && Objects.equals(this.help, that.help);
    }

    public int hashCode() {
        return Objects.hash(this.parameter, this.type, this.formal, this.defaultValue, this.defaultValueWhenFlag, this.keys, this.mandatoryKey, this.help);
    }
}

