/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.shell.CompletingParsedLine;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.Shell;
import org.springframework.shell.jline.ExtendedDefaultParser;
import org.springframework.shell.jline.InteractiveShellApplicationRunner;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.shell.jline.ScriptShellApplicationRunner;

@Configuration
public class JLineShellAutoConfiguration {
    @Autowired
    private PromptProvider promptProvider;
    @Autowired
    @Lazy
    private History history;
    @Autowired
    private Shell shell;

    @Bean(destroyMethod="close")
    public Terminal terminal() {
        try {
            return TerminalBuilder.builder().build();
        }
        catch (IOException e) {
            throw new BeanCreationException("Could not create Terminal: " + e.getMessage());
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.shell.interactive", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public ApplicationRunner interactiveApplicationRunner(Parser parser, Environment environment) {
        return new InteractiveShellApplicationRunner(this.lineReader(), this.promptProvider, parser, this.shell, environment);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.shell.script", value={"spring.shell.script"}, havingValue="true", matchIfMissing=true)
    public ApplicationRunner scriptApplicationRunner(Parser parser, ConfigurableEnvironment environment) {
        return new ScriptShellApplicationRunner(parser, this.shell, environment);
    }

    @Bean
    @ConditionalOnMissingBean(value={PromptProvider.class})
    public PromptProvider promptProvider() {
        return () -> new AttributedString((CharSequence)"shell:>", AttributedStyle.DEFAULT.foreground(3));
    }

    @Bean
    public CompleterAdapter completer() {
        return new CompleterAdapter();
    }

    @PostConstruct
    public void lateInit() {
        this.completer().setShell(this.shell);
    }

    @Bean
    public Parser parser() {
        ExtendedDefaultParser parser = new ExtendedDefaultParser();
        parser.setEofOnUnclosedQuote(true);
        parser.setEofOnEscapedNewLine(true);
        return parser;
    }

    @Bean
    public LineReader lineReader() {
        LineReaderBuilder lineReaderBuilder = LineReaderBuilder.builder().terminal(this.terminal()).appName("Spring Shell").completer((Completer)this.completer()).history(this.history).highlighter(new Highlighter(){

            public AttributedString highlight(LineReader reader, String buffer) {
                int l = 0;
                String best = null;
                for (String command : JLineShellAutoConfiguration.this.shell.listCommands().keySet()) {
                    if (!buffer.startsWith(command) || command.length() <= l) continue;
                    l = command.length();
                    best = command;
                }
                if (best != null) {
                    return new AttributedStringBuilder(buffer.length()).append(best, AttributedStyle.BOLD).append((CharSequence)buffer.substring(l)).toAttributedString();
                }
                return new AttributedString((CharSequence)buffer, AttributedStyle.DEFAULT.foreground(1));
            }
        }).parser(this.parser());
        LineReader lineReader = lineReaderBuilder.build();
        lineReader.unsetOpt(LineReader.Option.INSERT_TAB);
        return lineReader;
    }

    static List<String> sanitizeInput(List<String> words) {
        words = words.stream().map(s -> s.replaceAll("^\\n+|\\n+$", "")).map(s -> s.replaceAll("\\n+", " ")).collect(Collectors.toList());
        return words;
    }

    public static class CompleterAdapter
    implements Completer {
        private Shell shell;

        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            CompletingParsedLine cpl = line instanceof CompletingParsedLine ? (CompletingParsedLine)line : t -> t;
            CompletionContext context = new CompletionContext(JLineShellAutoConfiguration.sanitizeInput(line.words()), line.wordIndex(), line.wordCursor());
            List<CompletionProposal> proposals = this.shell.complete(context);
            proposals.stream().map(p -> new Candidate(p.dontQuote() ? p.value() : cpl.emit(p.value()).toString(), p.displayText(), p.category(), p.description(), null, null, true)).forEach(candidates::add);
        }

        public void setShell(Shell shell) {
            this.shell = shell;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={History.class})
    public static class HistoryConfiguration {
        @Autowired
        @Lazy
        private History history;

        @Bean
        public History history(LineReader lineReader, @Value(value="${spring.application.name:spring-shell}.log") String historyPath) {
            lineReader.setVariable("history-file", (Object)Paths.get(historyPath, new String[0]));
            return new DefaultHistory(lineReader);
        }

        @EventListener
        public void onContextClosedEvent(ContextClosedEvent event) throws IOException {
            this.history.save();
        }
    }
}

